// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/aws/amazon-ecs-cli/ecs-cli/modules/cli/compose/entity (interfaces: ProjectEntity)

// Package mock_entity is a generated GoMock package.
package mock_entity

import (
	reflect "reflect"

	context "github.com/aws/amazon-ecs-cli/ecs-cli/modules/cli/compose/context"
	types "github.com/aws/amazon-ecs-cli/ecs-cli/modules/cli/compose/entity/types"
	cache "github.com/aws/amazon-ecs-cli/ecs-cli/modules/utils/cache"
	ecs "github.com/aws/aws-sdk-go/service/ecs"
	project "github.com/docker/libcompose/project"
	gomock "github.com/golang/mock/gomock"
)

// MockProjectEntity is a mock of ProjectEntity interface
type MockProjectEntity struct {
	ctrl     *gomock.Controller
	recorder *MockProjectEntityMockRecorder
}

// MockProjectEntityMockRecorder is the mock recorder for MockProjectEntity
type MockProjectEntityMockRecorder struct {
	mock *MockProjectEntity
}

// NewMockProjectEntity creates a new mock instance
func NewMockProjectEntity(ctrl *gomock.Controller) *MockProjectEntity {
	mock := &MockProjectEntity{ctrl: ctrl}
	mock.recorder = &MockProjectEntityMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockProjectEntity) EXPECT() *MockProjectEntityMockRecorder {
	return m.recorder
}

// Context mocks base method
func (m *MockProjectEntity) Context() *context.ECSContext {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Context")
	ret0, _ := ret[0].(*context.ECSContext)
	return ret0
}

// Context indicates an expected call of Context
func (mr *MockProjectEntityMockRecorder) Context() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Context", reflect.TypeOf((*MockProjectEntity)(nil).Context))
}

// Create mocks base method
func (m *MockProjectEntity) Create() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Create")
	ret0, _ := ret[0].(error)
	return ret0
}

// Create indicates an expected call of Create
func (mr *MockProjectEntityMockRecorder) Create() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Create", reflect.TypeOf((*MockProjectEntity)(nil).Create))
}

// Down mocks base method
func (m *MockProjectEntity) Down() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Down")
	ret0, _ := ret[0].(error)
	return ret0
}

// Down indicates an expected call of Down
func (mr *MockProjectEntityMockRecorder) Down() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Down", reflect.TypeOf((*MockProjectEntity)(nil).Down))
}

// EntityType mocks base method
func (m *MockProjectEntity) EntityType() types.Type {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EntityType")
	ret0, _ := ret[0].(types.Type)
	return ret0
}

// EntityType indicates an expected call of EntityType
func (mr *MockProjectEntityMockRecorder) EntityType() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EntityType", reflect.TypeOf((*MockProjectEntity)(nil).EntityType))
}

// GetTags mocks base method
func (m *MockProjectEntity) GetTags() ([]*ecs.Tag, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTags")
	ret0, _ := ret[0].([]*ecs.Tag)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTags indicates an expected call of GetTags
func (mr *MockProjectEntityMockRecorder) GetTags() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTags", reflect.TypeOf((*MockProjectEntity)(nil).GetTags))
}

// Info mocks base method
func (m *MockProjectEntity) Info(arg0 bool, arg1 string) (project.InfoSet, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Info", arg0, arg1)
	ret0, _ := ret[0].(project.InfoSet)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Info indicates an expected call of Info
func (mr *MockProjectEntityMockRecorder) Info(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Info", reflect.TypeOf((*MockProjectEntity)(nil).Info), arg0, arg1)
}

// LoadContext mocks base method
func (m *MockProjectEntity) LoadContext() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LoadContext")
	ret0, _ := ret[0].(error)
	return ret0
}

// LoadContext indicates an expected call of LoadContext
func (mr *MockProjectEntityMockRecorder) LoadContext() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LoadContext", reflect.TypeOf((*MockProjectEntity)(nil).LoadContext))
}

// Run mocks base method
func (m *MockProjectEntity) Run(arg0 map[string][]string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Run", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// Run indicates an expected call of Run
func (mr *MockProjectEntityMockRecorder) Run(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Run", reflect.TypeOf((*MockProjectEntity)(nil).Run), arg0)
}

// Scale mocks base method
func (m *MockProjectEntity) Scale(arg0 int) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Scale", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// Scale indicates an expected call of Scale
func (mr *MockProjectEntityMockRecorder) Scale(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Scale", reflect.TypeOf((*MockProjectEntity)(nil).Scale), arg0)
}

// SetTaskDefinition mocks base method
func (m *MockProjectEntity) SetTaskDefinition(arg0 *ecs.TaskDefinition) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetTaskDefinition", arg0)
}

// SetTaskDefinition indicates an expected call of SetTaskDefinition
func (mr *MockProjectEntityMockRecorder) SetTaskDefinition(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTaskDefinition", reflect.TypeOf((*MockProjectEntity)(nil).SetTaskDefinition), arg0)
}

// Start mocks base method
func (m *MockProjectEntity) Start() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Start")
	ret0, _ := ret[0].(error)
	return ret0
}

// Start indicates an expected call of Start
func (mr *MockProjectEntityMockRecorder) Start() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Start", reflect.TypeOf((*MockProjectEntity)(nil).Start))
}

// Stop mocks base method
func (m *MockProjectEntity) Stop() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Stop")
	ret0, _ := ret[0].(error)
	return ret0
}

// Stop indicates an expected call of Stop
func (mr *MockProjectEntityMockRecorder) Stop() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Stop", reflect.TypeOf((*MockProjectEntity)(nil).Stop))
}

// TaskDefinition mocks base method
func (m *MockProjectEntity) TaskDefinition() *ecs.TaskDefinition {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TaskDefinition")
	ret0, _ := ret[0].(*ecs.TaskDefinition)
	return ret0
}

// TaskDefinition indicates an expected call of TaskDefinition
func (mr *MockProjectEntityMockRecorder) TaskDefinition() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TaskDefinition", reflect.TypeOf((*MockProjectEntity)(nil).TaskDefinition))
}

// TaskDefinitionCache mocks base method
func (m *MockProjectEntity) TaskDefinitionCache() cache.Cache {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TaskDefinitionCache")
	ret0, _ := ret[0].(cache.Cache)
	return ret0
}

// TaskDefinitionCache indicates an expected call of TaskDefinitionCache
func (mr *MockProjectEntityMockRecorder) TaskDefinitionCache() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TaskDefinitionCache", reflect.TypeOf((*MockProjectEntity)(nil).TaskDefinitionCache))
}

// Up mocks base method
func (m *MockProjectEntity) Up() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Up")
	ret0, _ := ret[0].(error)
	return ret0
}

// Up indicates an expected call of Up
func (mr *MockProjectEntityMockRecorder) Up() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Up", reflect.TypeOf((*MockProjectEntity)(nil).Up))
}
