/*-
 * Copyright (c) 2014-2017 Carsten Sonne Larsen <cs@innolan.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Project homepage:
 * https://amath.innolan.net
 * 
 */

#ifndef AMATH_SYMBOL_H
#define AMATH_SYMBOL_H

/**
 * @file  symbol.h
 * @brief Symbol defitions used by other classes
 */

/**
 * @brief Symbols generated by the Lexer
 */
typedef enum
{
    symunknown,
    symident,
    symqident,
    symnumber,
    symfactorial,
    symplus,
    symminus,
    symtimes,
    symslash,
    sympower,
    symabsolute,
    symassign,
    symlparen,
    symrparen,
    symfuncsqrt,
    symfunccbrt,
    symfunclog,
    symfuncln,
    symhelp,
    symeval,
    symdelete,
    symall,
    symclear,
    symdef,
    symexit,
    symoperator,
    symstatement,
    symfunction,
    symvariable,
    symtrigon,
    symhyper,
    symearly,
    symcomplex,
    syme,
    sympi,
    symi,
    symins,
    symdelimiter,
    symend,
    symshow,
    symlist,
    symload,
    symsave,
    symexecute,
    syminput,
    symoutput,
    symdigits,
    symdec,
    symhex,
    symbin,
    symoct,
    symmem,
    symprefs,
    symprompt,
    symversion,
    symplot,
    symdraw,
    symabout,
    symlicense
} Symbol;

#endif
