/*  SpiralSynth
 *  Copyright (C) 2000 David Griffiths <dave@blueammonite.f9.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>

#include "SynthInfo.h"

float RandFloat(float s=0.0f, float e=1.0f)
{
	return s+((rand()%10000/10000.0)*(e-s));
}

void CopyBuffer(short *from, short *to)
{
	for (int n=0; n<SynthInfo::BUFSIZE; n++)
	{
		to[n]=from[n];
	}
}

int    SynthInfo::BUFSIZE     = 512;	
int    SynthInfo::SAMPLERATE  = 44100;
long   SynthInfo::MAXSAMPLE   = 32767;
float  SynthInfo::VALUECONV   = 1.0f/MAXSAMPLE;
bool   SynthInfo::WANTMIDI    = true;
int    SynthInfo::FILTERGRAN  = 50;
string SynthInfo::OUTPUTFILE  = "/dev/dsp";
string SynthInfo::MIDIFILE    = "/dev/midi";
int    SynthInfo::POLY        = 2;
bool   SynthInfo::REALTIMEOUT = true;
string SynthInfo::KEYMAP("zsxdcvgbhnjmq2w3er5t6y7ui9o0p[");
int    SynthInfo::NKEYS       = 30;

int SynthInfo::GUI_COLOUR = 179;
int SynthInfo::GUIBG_COLOUR = 0;

SynthInfo* SynthInfo::m_SynthInfo=NULL;

SynthInfo* SynthInfo::Get()
{
	if (!m_SynthInfo)
	{
		m_SynthInfo = new SynthInfo;
	}
	
	return m_SynthInfo;
}

void SynthInfo::LoadPrefs()
{
	string rcfn(m_HomeDir+"/.Spiralrc");
	ifstream i(rcfn.c_str());
	
	if (!i)
	{
		cerr<<".Spiralrc synth config file not found, creating default\n"<<endl;
		SavePrefs();
		return;
	}	
	
	char temp[256];
	
	i>>temp>>temp>>temp;
	
	i>>temp>>temp>>BUFSIZE;
	i>>temp>>temp>>SAMPLERATE;
	i>>temp>>temp>>WANTMIDI;
	i>>temp>>temp>>FILTERGRAN;
	i>>temp>>temp>>OUTPUTFILE;
	i>>temp>>temp>>MIDIFILE;
	i>>temp>>temp>>REALTIMEOUT;
	i>>temp>>temp>>KEYMAP;
	i>>temp>>temp>>POLY;
}

void SynthInfo::SavePrefs()
{
	string rcfn(m_HomeDir+"/.Spiralrc");
	ofstream o(rcfn.c_str());
	
	o<<"SpiralSynth resource file"<<endl<<endl;
	o<<"BufferSize        = "<<BUFSIZE<<endl;	
	o<<"Samplerate        = "<<SAMPLERATE<<endl;
	o<<"WantMidi          = "<<WANTMIDI<<endl;
	o<<"FilterGranularity = "<<FILTERGRAN<<endl;
	o<<"Output            = "<<OUTPUTFILE<<endl;
	o<<"Midi              = "<<MIDIFILE<<endl;
	o<<"WantRealtimeOut   = "<<REALTIMEOUT<<endl;
	o<<"KeyMap            = "<<KEYMAP<<endl;
	o<<"Polyphony         = "<<POLY<<endl;
}	
