/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <math.h>
#include "NoteTable.h"
#include "SpiralInfo.h"

#ifndef DELAY
#define DELAY

class Delay
{
public:
	Delay();
	~Delay();

	void  SetDelay(float s) {m_Delay=s;}	
	void  SetFeedback(float s) {m_Feedback=s;}	
	float GetDelay() {return m_Delay;}	
	float GetFeedback() {return m_Feedback;}	
	void  GetOutput(short *data);
	void  Randomise();

private:

	float *m_Buffer;
	long   m_Write;
	float  m_Delay;
	float  m_Feedback;
	
	friend istream &operator>>(istream &s, Delay &o);
	friend ostream &operator<<(ostream &s, Delay &o);
};

istream &operator>>(istream &s, Delay &o);
ostream &operator<<(ostream &s, Delay &o);

#endif
