/*  SpiralRoute
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "RouteGUI.h"
#include <stdlib.h>

RouteGUI::RouteGUI()
{
}
		
void RouteGUI::CreateGUI(int xoff, int yoff, char *name)
{
	m_RoutingGroup = new Fl_Group(xoff, yoff, 170, 55, name);
    m_RoutingGroup->type(1);
	m_RoutingGroup->box(FL_UP_BOX);
    m_RoutingGroup->labeltype(FL_ENGRAVED_LABEL);
    m_RoutingGroup->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
	m_RoutingGroup->user_data((void*)(this));
	 	
	m_Osc1Freq = new Fl_Button(xoff+15, yoff+17, 50, 16, "Osc1Freq");
	m_Osc1Freq->type(1);
	m_Osc1Freq->labelsize(10);
	m_Osc1Freq->callback((Fl_Callback*)cb_Osc1Freq);
	
	m_Osc1PW = new Fl_Button(xoff+65, yoff+17, 50, 16, "Osc1 PW");
	m_Osc1PW->type(1);
	m_Osc1PW->labelsize(10);
	m_Osc1PW->callback((Fl_Callback*)cb_Osc1PW);
	
	m_Osc2Freq = new Fl_Button(xoff+115, yoff+17, 50, 16, "Osc2Freq");
	m_Osc2Freq->type(1);
	m_Osc2Freq->labelsize(10);
	m_Osc2Freq->callback((Fl_Callback*)cb_Osc2Freq);
	
	m_Osc2PW = new Fl_Button(xoff+15, yoff+33, 50, 16, "Osc2 PW");
	m_Osc2PW->type(1);
	m_Osc2PW->labelsize(10);
	m_Osc2PW->callback((Fl_Callback*)cb_Osc2PW);
	
	m_FilterC = new Fl_Button(xoff+65, yoff+33, 50, 16, "Filter C");
	m_FilterC->type(1);
	m_FilterC->labelsize(10);
	m_FilterC->callback((Fl_Callback*)cb_FilterC);
	
	m_FilterR = new Fl_Button(xoff+115, yoff+33, 50, 16, "Filter R");
	m_FilterR->type(1);
	m_FilterR->labelsize(10);
	m_FilterR->callback((Fl_Callback*)cb_FilterR);
	
	m_RoutingGroup->end();   
}

void RouteGUI::UpdateValues()
{		
    m_Osc1Freq->value(m_Button & OSC1FREQ);
	m_Osc1PW->value(m_Button & OSC1PW);
	m_Osc2Freq->value(m_Button & OSC2FREQ);
	m_Osc2PW->value(m_Button & OSC2PW);
	m_FilterC->value(m_Button & FILTERC);
	m_FilterR->value(m_Button & FILTERR);
}

void RouteGUI::Randomise()
{
	m_Button=rand()%LAST+1;
}

istream &operator>>(istream &s, RouteGUI &o)
{
	s>>o.m_Button;
	return s;
}

ostream &operator<<(ostream &s, RouteGUI &o)
{
	s<<o.m_Button<<" ";
	return s;
}


//// Callbacks ////
inline void RouteGUI::cb_Osc1Freq_i(Fl_Knob* o, void* v) 
{  
  if (o->value()) m_Button = m_Button | OSC1FREQ;
  else m_Button = m_Button ^ OSC1FREQ;
}
void RouteGUI::cb_Osc1Freq(Fl_Knob* o, void* v) 
{ ((RouteGUI*)(o->parent()->user_data()))->cb_Osc1Freq_i(o,v); }



inline void RouteGUI::cb_Osc1PW_i(Fl_Knob* o, void* v) 
{ 
  if (o->value()) m_Button = m_Button | OSC1PW;
  else m_Button = m_Button ^ OSC1PW;
}
void RouteGUI::cb_Osc1PW(Fl_Knob* o, void* v) 
{ ((RouteGUI*)(o->parent()->user_data()))->cb_Osc1PW_i(o,v); }



inline void RouteGUI::cb_Osc2Freq_i(Fl_Knob* o, void* v) 
{
  if (o->value()) m_Button = m_Button | OSC2FREQ;
  else m_Button = m_Button ^ OSC2FREQ;
}
void RouteGUI::cb_Osc2Freq(Fl_Knob* o, void* v) 
{ ((RouteGUI*)(o->parent()->user_data()))->cb_Osc2Freq_i(o,v); }



inline void RouteGUI::cb_Osc2PW_i(Fl_Knob* o, void* v) 
{ 
  if (o->value()) m_Button = m_Button | OSC2PW;
  else m_Button = m_Button ^ OSC2PW;
}
void RouteGUI::cb_Osc2PW(Fl_Knob* o, void* v) 
{ ((RouteGUI*)(o->parent()->user_data()))->cb_Osc2PW_i(o,v); }



inline void RouteGUI::cb_FilterC_i(Fl_Knob* o, void* v) 
{
  if (o->value()) m_Button = m_Button | FILTERC;
  else m_Button = m_Button ^ FILTERC;
}
void RouteGUI::cb_FilterC(Fl_Knob* o, void* v) 
{ ((RouteGUI*)(o->parent()->user_data()))->cb_FilterC_i(o,v); }



inline void RouteGUI::cb_FilterR_i(Fl_Knob* o, void* v) 
{
  if (o->value()) m_Button = m_Button | FILTERR;
  else m_Button = m_Button ^ FILTERR;
}
void RouteGUI::cb_FilterR(Fl_Knob* o, void* v) 
{ ((RouteGUI*)(o->parent()->user_data()))->cb_FilterR_i(o,v); }

