/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include "Widgets/Fl_Knob.H"
#include <FL/Fl_Value_Output.H>

#include "GUIBase.h"

#ifndef PATCHBANKGUI
#define PATCHBANKGUI

const int NPSEL=20;

class PatchBankGUI : public GUIBase
{
public:
	PatchBankGUI();
	
	virtual void CreateGUI(int xoff, int yoff, char *name);

	// returns current patch no. if changed, -1 if it hasn't changed
	// since it was last called.
	int GetOutput();
	
	// sends the value of Save, and sets it to 0 after.
	bool IsSaving();
		
private:

	int m_CurrentPatch;
	int m_PatchList[NPSEL]; 

	Fl_Group 		*GUIPatchBankGroup;
	Fl_Button		*Patch[NPSEL];
	Fl_Knob			*Select;
	Fl_Button		*Save;
	Fl_Button		*Rand;
	Fl_Value_Output *Num;
	
	//// Callbacks ////
	
	inline void cb_Patch_i(Fl_Button* o, void* v);
    static void cb_Patch(Fl_Button* o, void* v);
	inline void cb_Select_i(Fl_Knob* o, void* v);
	static void cb_Select(Fl_Knob* o, void* v); 
	inline void cb_Save_i(Fl_Button* o, void* v);
    static void cb_Save(Fl_Button* o, void* v);
	inline void cb_Rand_i(Fl_Button* o, void* v);
    static void cb_Rand(Fl_Button* o, void* v);
};

#endif
