/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "DelayGUI.h"

DelayGUI::DelayGUI(Delay *o)
{
	m_delay=o;
	if (!m_delay) cerr<<"WARNING: Delay not correctly set up"<<endl;
}
		
void DelayGUI::CreateGUI(int xoff, int yoff, char *name)
{
	 Fl_Group* o = GUIDelayGroup = new Fl_Group(xoff, yoff, 85, 110, name);
      o->type(1);
	  o->box(FL_UP_BOX);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
	  o->user_data((void*)(this));
       	  
	  DelayA = new Fl_PawfalSlider(xoff+10, yoff+20, 20, 75, "Delay");
	  DelayA->type(4);
	  DelayA->selection_color(SpiralInfo::GUI_COLOUR);
      DelayA->labelsize(10);
	  DelayA->maximum(1);
      DelayA->step(0.01);
      DelayA->value(0.5);
      DelayA->callback((Fl_Callback*)cb_Delay);
	  
	  Feedback = new Fl_PawfalSlider(xoff+45, yoff+20, 20, 75, "Feedback");
	  Feedback->type(4);
	  Feedback->selection_color(SpiralInfo::GUI_COLOUR);
      Feedback->labelsize(10);
	  Feedback->maximum(1.0);
      Feedback->step(0.01);
      Feedback->value(0.5);
      Feedback->callback((Fl_Callback*)cb_Feedback);
	  
      o->end();
    
}

void DelayGUI::UpdateValues()
{
	DelayA->value(1.0f-m_delay->GetDelay());
	Feedback->value(1.0f-m_delay->GetFeedback());
}

//// Callbacks ////

inline void DelayGUI::cb_Delay_i(Fl_Value_Slider* o, void* v) 
{ m_delay->SetDelay(1.0f-o->value()); }
void DelayGUI::cb_Delay(Fl_Value_Slider* o, void* v) 
{ ((DelayGUI*)(o->parent()->user_data()))->cb_Delay_i(o,v); }

inline void DelayGUI::cb_Feedback_i(Fl_PawfalSlider* o, void* v) 
{ m_delay->SetFeedback(1.0f-o->value()); }
void DelayGUI::cb_Feedback(Fl_PawfalSlider* o, void* v) 
{ ((DelayGUI*)(o->parent()->user_data()))->cb_Feedback_i(o,v); }

