/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.PdfImageObject;
import com.itextpdf.text.pdf.parser.Vector;
import java.io.IOException;

public class ImageRenderInfo {
    private final Matrix ctm;
    private final PdfIndirectReference ref;
    private PdfImageObject imageObject = null;

    private ImageRenderInfo(Matrix ctm, PdfIndirectReference ref) {
        this.ctm = ctm;
        this.ref = ref;
    }

    public static ImageRenderInfo createForXObject(Matrix ctm, PdfIndirectReference ref) {
        return new ImageRenderInfo(ctm, ref);
    }

    protected static ImageRenderInfo createdForEmbeddedImage(Matrix ctm, PdfImageObject imageObject) {
        ImageRenderInfo renderInfo = new ImageRenderInfo(ctm, null);
        renderInfo.imageObject = imageObject;
        return renderInfo;
    }

    public PdfImageObject getImage() throws IOException {
        this.prepareImageObject();
        return this.imageObject;
    }

    private void prepareImageObject() throws IOException {
        if (this.imageObject != null) {
            return;
        }
        PRStream stream = (PRStream)PdfReader.getPdfObject(this.ref);
        this.imageObject = new PdfImageObject(stream);
    }

    public Vector getStartPoint() {
        return new Vector(0.0f, 0.0f, 1.0f).cross(this.ctm);
    }

    public Matrix getImageCTM() {
        return this.ctm;
    }

    public float getArea() {
        return this.ctm.getDeterminant();
    }

    public PdfIndirectReference getRef() {
        return this.ref;
    }
}

