<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

June 12, 2020

Host: Carol Payne

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [x] Alexa Zalipyatskikh - Autodesk
  * [x] Troy Sobotka
  * [x] Matthias Scharfenberg - ILM

# **OCIO Documentation Working Group Meeting Notes**

* Overview (Carol):
    - We've been discussing in TSC that OCIO v2 needs to launch with 
      documentation, to help people get familiar with what's changed, and how 
      to implement. It's one thing to have a feature complete v2, but another 
      to know how to use it. 
    - The plan is to completely revamp documentation. Sean is leading the API 
      doc revamp.
    - Want to discuss OCIO website user stories. What does the user journey 
      look like? How do we help people of different expertise and backgrounds 
      navigate OCIO docs. Typically docs are written with a specific person in 
      mind, but we need to consider many.
    - The how and what can be discussed later. Need to discuss overall 
      organization structure first.

* Documentation structure:
    - [Google Doc](https://docs.google.com/document/d/17IQR2tRYxqGXkExOLvP9S_dMkOkOID-NIIAGXGfyxNk/edit)
    - Summary of three proposed structures:
        - Structure 1:
          - Organize docs around artists, studio config maintainers, TDs, DCC 
            maintainers, and OCIO contributors.
          - Put relevant info in terms of who is looking at it.
          - Challenge would be how to deal with duplicate info, since some 
            topics will affect multiple roles.
        - Structure 2:
          - Similar to what's there now, with some clean up and reorganization.
          - Doesn't deal well with different types of users finding info. 
            Doesn't contextualize user stories.
          - Where do we put workflow examples and tutorials to be accessible?
        - Structure 3:
          - Combo of 1 and 2 (see doc)
          - Breaking out site into sections like config, tools, API, and within 
            each make point to break out subsections for intended audiences, 
            following a general overview. Notes would be added for specific 
            roles to read about relevant topics.
    - Michael: Structure 3 seems like a good balance.
    - Alexa: Have written lots of docs. Customizing docs for specific roles is 
      hard to maintain; a lot of work to keep up with different groups. 
      Recommend checking out RabbitMQ docs. Takes you through a progression of 
      easy to hard, slowly introducing topics. Combo structure good for gradual 
      introduction to technical info. Gives relevant info at the right time.
        - This quadrant doc structure is really helpful: 
          [The documentation system](https://documentation.divio.com/)
        - 4 quadrants of documentation: tutorials (from 0 to examples, holding 
          hand), how to guides (more specific, how do I do A, B, etc. Walks 
          through how to get something done), explanation, reference (API 
          docs).
    - Carol: Should we show users how to use OCIO in DCCs (like Nuke) on the 
      website, or just show how to set env vars so that Nuke can pick OCIO up?
    - Alexa: Better to link to DCC vendors own guides.
    - Michael: There is some of that on the site now in the Compatible Software 
      page, which was updated recently: 
      [Compatible Software](https://github.com/AcademySoftwareFoundation/OpenColorIO/blob/main/docs/CompatibleSoftware.rst)
    - Carol: Tricky to know which vendors to include tutorials for.
    - Alexa: Could be better to explain the config, and what each part means. 
      It's difficult to find everything right now.
    - Carol: If there's no objections, suggest moving forward with structure 3. 
      It allows us to first write docs like in example 2 - traditional tree, 
      broken up nicely - and then take those components and add coverage for 
      user cases and make specific call outs for specific groups; artists, TDs, 
      etc. 
    - Alexa: Good for developers to update docs as new work is contributed, but 
      how do users update docs?
    - Doug: We have talked about that and discussed different approaches. Would 
      be good to avoid contributors having to deal with Sphinx if possible.
    - Alexa: Sphinx is great, but it does make it hard to update docs for those 
      not familiar.
    - Carol: I included some references in the Google doc on what other 
      projects have done to improve this. Many have big notes at the top or 
      bottom of pages encouraging contribution. Usually includes a link to take 
      users to open GitHub issue. Suggest easier structure if possible, but 
      it's harder to engineer. My first thought was to use a wiki, and keep it 
      separate from API generated docs, editable in the website. The more I 
      investigated though, the wiki didn't seem to give us much more, compared to 
      a static site with markdown. If the overhead is links to report issues 
      around docs, and encourage users to contribute fixes, that barrier is not 
      too high. Hopefully most people will follow through with that. Someone 
      with GH knowledge can do the work.
    - Doug: So someone would create an issue, but someone else would do the 
      update. It's not a huge barrier to entry, since they can submit an edit 
      without a PR. 
    - Carol: If someone is comfortable they can submit a PR - need to have CLA 
      signed, etc. I no longer think the wiki is worth it.
    - Doug: Can you discuss structure 3 a bit? How would it be broken down?
    - Carol: The doc is not complete, but general thought is to have cut and 
      dry components, but with added categories and references with different 
      use cases for different roles. Easy to hard progression, but not labeled 
      as such. Start with "what is it?", an overview, and go from there to 
      underlying details of sub-components with examples and how they fit 
      together. Then user guide for steps to implement, and then a section for 
      DCC implementors (what do they need to know to use and test; how to know 
      it's working, etc.). 
    - Matthias: Where are docs about individual transforms? API or config 
      structure? What transforms exist and how do they go together to make a 
      color space.
    - Carol: Could be part of config author section, following structure and 
      overview. Transforms could follow how to implement color spaces. TDs 
      wouldn't need to know that low level.
    - Doug: Alexa discussed taxonomy of four types of documentation. Is this a 
      way of thinking about docs? Are we talking about the reference section.
    - Carol: Combo of bottom two quadrants: explanation and reference. 
    - Doug: Is first section example and second section reference?
    - Carol: Could go different ways. Don't want to tie us into writing 
      examples for everything. Won't be needed for every component. Should be 
      woven into reference as we see fit. Reference docs will be first step for 
      writing docs. Then we look at for different roles; what needs to be 
      explained more?
    - Alexa: Need to have recommendations in there and gotchas.
    - Doug: Yes, need to steer people in the right direction. Trying to do that 
      with code, apphelpers and code examples, but equally important is best 
      practices for config authoring.
    - Troy: Stepping through building config is big deal. Is there a current 
      API call to build a bare minimum config skeleton?
    - Doug: There is a call to give you a minimal config, but not much.
    - Sean: what would that include?
    - Troy: It would have all the things needed for a config to pass a sanity 
      check. May be possible to combine "how to guide" with reference. Could 
      link them, to step by step build up.
    - Carol: Would be great to be able to generate reference config.
    - Michael: Could possibly reference the ACES config.
    - Alexa: we get a lot of questions for people trying to setup OCIO configs. 
      Good to cover that.
    - Carol: There's a lot of space to build on docs. Add tutorial for 
      authoring config from ground up. It could sit in docs, but under 
      tutorials and reference back to sections of documentation. If base 
      structure covers basis, it becomes easier to write tutorials.
    - Sean: The builtin/bundled apps are code examples. The docs can point to 
      configs repo, other docs, API, code examples, etc. Sphinx and reST will 
      help with that a lot. Feature called intersphinx that can pull Sphinx 
      docs from other projects; could possibly be utilized.

* API docs discussion (Sean):
    - Using pybind11/mitsuba2 method (makedoc) that pulls docstrings from 
      header as long as the header is formatted in doxygen style.
    - Spits out header file with string literals which a Python script then 
      pulls data from.
    - Only need to write docs in C++ headers. CMake will pull those. Docstrings 
      get compiled into bindings and then docstrings match between C++ and 
      Python. Using autodoc and Breathe, can build docs.
    - Have ganged Python and C++ tabs through API docs to see both on same 
      page, with shared descriptions.
    - Handles listing parameters.
    - Doug: How do you handle spots where C++ and python differ?
    - Sean: May need to write docstring in Python bindings to explain the 
      differences.
    - Michael: Having to document differences in Python binding docstrings 
      could help call out where the APIs differ in the code, as a benefit.
    - Sean: VuePress has some style issues that need to be resolved.
    - Michael: Might be able to fix signature of PyIterator base class.
    - Sean: Also need to get rid of redundant 'self' param.

* API and website combined or separate?
    - Sean: Sphinx/RTD could just generate reference section of docs (in four 
      quadrant diagram). And use a static site for everything else?
    - Carol: If we separate them, can we still link between them easily?
    - Sean: Code references could get messy if they are kept separate.
    - Michael: Could reach out to LF creative services for help with design, 
      branding etc. Front end stuff.
    - Carol: If we kept it together all docs would be in reST. Would generate 
      everything.
    - Alexa: RTD has simpler markdown, but not tried for C++ - referring to 
      RTD service.
    - Michael: Might use Sphinx in background and just hide it a bit.
    - Alexa: Markdown is easier to migrate than reST.
    - Sean: Could keep the two upper quadrants in markdown. RTD also has an 
      "edit in github" link to ease fixing errors.
    - Michael: Need to find a way to sign-off commits via GH interface.
    - Sean: Can do GH issue templates; not sure about commits.
    - Michael: Can document commit instructions.
    - Sean: We can add that to CONTRIBUTORS.md. 
    - Sean: Need to decide if we should do the dual system? Or use Sphinx for 
      everything?
    - Michael: keeping them separate could be problematic since some parts 
      would be versioned and others not. Easy to drift.
    - Carol: Bottom line is we want good up to date maintainable documentation. 
      More important than the prettiness of the site. Code snippets getting 
      updated without tracking would be a big benefit. Could have a nice static 
      splash page still, which can be manually updated separate from 
      documentation.
    - Alexa: Django docs do this well. Good example. Landing page explaining 
      how docs are organized, with "getting started" links.
    - Sean: Could have www/ subdirectory in repo for the static site portion, 
      hosted in GH pages.
    - Michael: GH pages is nice for that. Just commit to that branch and its 
      live.
    - Sean: If we have a page to layout general descriptions, we'll see what 
      areas are better for a website and can evolve naturally.
    - Carol: Keeping in mind the desire to keep everything tied together for 
      ease of updating. As long as we keep that in mind.
    - Sean: Django layout is good since the site could point to multiple GH 
      repos and projects, configs, etc.
    - Carol: Next step is to do big picture and break up work.
    - Michael: GH Projects kanban board. Create issue per section and add to 
      that project.
    - Carol: Can do comprehensive overview of what needs to be done, and create 
      issues. Should we separate API from the rest of it? Is that done?
    - Sean: Plenty of methods for documentation. Should we have another repo?
    - Michael: Maybe orphaned branch instead of another repo?
    - Sean: Thinking of a new directory structure, etc.
    - Carol: Like the idea of having something separate that doesn't tie into 
      OCIO build system. 
    - Troy: Could do work in GH wiki to start. Accessible from git and can do 
      push.
    - All: Good idea.
    - Alexa: Want to have place to do brain dump up front and organize later.
    - Troy: Wiki image upload can utilize images from GH issues as a shortcut.
    - **TODO**: Sean and Alexa will work on Google doc to flesh out content 
      more.
    - Sean: Do we care about the theme? Or just use RTD?
    - Carol: Like how sphinx-press looks, but could get frontend assistance 
      from LF.
    - **TODO**: Michael to ask Emily about LF resources for frontend style 
      work.
    - Alexa: Also need to keep color blindness in mind.
    - Sean: Could possibly use VuePress for site too, to keep things together.
    - **TODO**: Sean to continue working on API docs.
    - Doug: We have been conforming header docs to existing style.
    - Sean: Will do one big push with new header doc syntax.
    - Doug: Existing solution is difficult, to get html and pdf both looking 
      good.
    - Michael: RTD can generate PDF, so don't need the 'pdf' target anymore.
    - Sean: Need to think about header docs more generically, since it goes to 
      C++ and Python.
    - Doug: If clarity in docs is needed, we can help.
