/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

public class zzku<K, V> {
    private final LinkedHashMap<K, V> zzabn;
    private int size;
    private int zzabo;
    private int zzabp;
    private int zzabq;
    private int zzabr;
    private int zzabs;
    private int zzabt;

    public zzku(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.zzabo = n;
        this.zzabn = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        zzku<K, V> zzku2 = this;
        synchronized (zzku2) {
            object = this.zzabn.get(key);
            if (object != null) {
                ++this.zzabs;
                return object;
            }
            ++this.zzabt;
        }
        zzku2 = this.create(key);
        if (zzku2 == null) {
            return null;
        }
        zzku zzku3 = this;
        synchronized (zzku3) {
            ++this.zzabq;
            object = this.zzabn.put(key, zzku2);
            if (object != null) {
                this.zzabn.put(key, object);
            } else {
                this.size += this.zzc(key, zzku2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, zzku2, object);
            return object;
        }
        this.trimToSize(this.zzabo);
        return (V)zzku2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        zzku zzku2 = this;
        synchronized (zzku2) {
            ++this.zzabp;
            this.size += this.zzc(key, value);
            v = this.zzabn.put(key, value);
            if (v != null) {
                this.size -= this.zzc(key, v);
            }
        }
        if (v != null) {
            this.entryRemoved(false, key, v, value);
        }
        this.trimToSize(this.zzabo);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v;
            K k;
            zzku zzku2 = this;
            synchronized (zzku2) {
                if (this.size < 0 || this.zzabn.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.zzabn.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.zzabn.entrySet().iterator().next();
                k = entry.getKey();
                v = entry.getValue();
                this.zzabn.remove(k);
                this.size -= this.zzc(k, v);
                ++this.zzabr;
            }
            this.entryRemoved(true, k, v, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int zzc(K k, V v) {
        int n = this.sizeOf(k, v);
        if (n < 0) {
            throw new IllegalStateException("Negative size: " + k + "=" + v);
        }
        return n;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n = this.zzabs + this.zzabt;
        int n2 = n != 0 ? 100 * this.zzabs / n : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.zzabo, this.zzabs, this.zzabt, n2);
    }
}

