/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appinvite;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class AppInviteReferral {
    private AppInviteReferral() {
    }

    public static boolean hasReferral(Intent referralIntent) {
        return referralIntent != null && referralIntent.getBundleExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE") != null;
    }

    public static boolean isOpenedFromPlayStore(Intent referralIntent) {
        return AppInviteReferral.hasReferral(referralIntent) && referralIntent.getBundleExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE").getBoolean("com.google.android.gms.appinvite.OPENED_FROM_PLAY_STORE", false);
    }

    public static String getInvitationId(Intent referralIntent) {
        Bundle bundle;
        if (referralIntent != null && (bundle = referralIntent.getBundleExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE")) != null) {
            return bundle.getString("com.google.android.gms.appinvite.INVITATION_ID");
        }
        return null;
    }

    public static String getDeepLink(Intent referralIntent) {
        Bundle bundle;
        if (referralIntent != null && (bundle = referralIntent.getBundleExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE")) != null) {
            return bundle.getString("com.google.android.gms.appinvite.DEEP_LINK");
        }
        return null;
    }

    public static Intent addPlayStoreReferrerToIntent(Intent playStoreReferrerIntent, Intent referralIntent) {
        Bundle bundle = AppInviteReferral.zzh(playStoreReferrerIntent);
        if (bundle != null && referralIntent != null) {
            referralIntent.putExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE", bundle);
        }
        return referralIntent;
    }

    public static Intent addReferralDataToIntent(String invitationId, String deepLink, Intent referralIntent) {
        if (referralIntent == null) {
            return null;
        }
        return referralIntent.putExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE", AppInviteReferral.zza(invitationId, deepLink, false));
    }

    private static Bundle zza(String string2, String string3, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putString("com.google.android.gms.appinvite.INVITATION_ID", string2);
        bundle.putString("com.google.android.gms.appinvite.DEEP_LINK", string3);
        bundle.putBoolean("com.google.android.gms.appinvite.OPENED_FROM_PLAY_STORE", bl);
        return bundle;
    }

    private static Bundle zzh(Intent intent) {
        if (intent == null || !intent.getAction().equals("com.android.vending.INSTALL_REFERRER") || intent.getStringExtra("referrer") == null) {
            return null;
        }
        String string2 = intent.getStringExtra("referrer");
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"AppInviteReferral", (String)("Error parsing Play Store referrer URL: " + string2));
            return null;
        }
        Uri uri = Uri.parse((String)("s://a.b.c?" + string2));
        String string3 = uri.getQueryParameter("invitation_id");
        String string4 = uri.getQueryParameter("deep_link_id");
        if (string3 == null && string4 == null) {
            Log.w((String)"AppInviteReferral", (String)("Missing  Referrer query params: " + string2));
            return null;
        }
        return AppInviteReferral.zza(string3, string4, true);
    }
}

