/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.Snapshots;

public final class SnapshotsImpl
implements Snapshots {
    @Override
    public int getMaxDataSize(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzsP();
    }

    @Override
    public int getMaxCoverImageSize(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzsQ();
    }

    @Override
    public Intent getSelectSnapshotIntent(GoogleApiClient apiClient, String title, boolean allowAddButton, boolean allowDelete, int maxSnapshots) {
        return Games.zzd(apiClient).zza(title, allowAddButton, allowDelete, maxSnapshots);
    }

    @Override
    public PendingResult<Snapshots.LoadSnapshotsResult> load(GoogleApiClient apiClient, final boolean forceReload) {
        return apiClient.zza(new LoadImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zze(this, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient apiClient, SnapshotMetadata metadata) {
        return this.open(apiClient, metadata.getUniqueName(), false);
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient apiClient, SnapshotMetadata metadata, int conflictPolicy) {
        return this.open(apiClient, metadata.getUniqueName(), false, conflictPolicy);
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient apiClient, String fileName, boolean createIfNotFound) {
        return this.open(apiClient, fileName, createIfNotFound, -1);
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient apiClient, final String fileName, final boolean createIfNotFound, final int conflictPolicy) {
        return apiClient.zzb(new OpenImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, fileName, createIfNotFound, conflictPolicy);
            }
        });
    }

    @Override
    public PendingResult<Snapshots.CommitSnapshotResult> commitAndClose(GoogleApiClient apiClient, final Snapshot snapshot, final SnapshotMetadataChange metadataChange) {
        return apiClient.zzb(new CommitImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, snapshot, metadataChange);
            }
        });
    }

    @Override
    public void discardAndClose(GoogleApiClient apiClient, Snapshot snapshot) {
        Games.zzd(apiClient).zza(snapshot);
    }

    @Override
    public PendingResult<Snapshots.DeleteSnapshotResult> delete(GoogleApiClient apiClient, final SnapshotMetadata metadata) {
        return apiClient.zzb(new DeleteImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzi(this, metadata.getSnapshotId());
            }
        });
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> resolveConflict(GoogleApiClient apiClient, String conflictId, Snapshot snapshot) {
        SnapshotMetadata snapshotMetadata = snapshot.getMetadata();
        SnapshotMetadataChange snapshotMetadataChange = new SnapshotMetadataChange.Builder().fromMetadata(snapshotMetadata).build();
        return this.resolveConflict(apiClient, conflictId, snapshotMetadata.getSnapshotId(), snapshotMetadataChange, snapshot.getSnapshotContents());
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> resolveConflict(GoogleApiClient apiClient, final String conflictId, final String snapshotId, final SnapshotMetadataChange metadataChange, final SnapshotContents snapshotContents) {
        return apiClient.zzb(new OpenImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, conflictId, snapshotId, metadataChange, snapshotContents);
            }
        });
    }

    @Override
    public SnapshotMetadata getSnapshotFromBundle(Bundle extras) {
        if (extras == null || !extras.containsKey("com.google.android.gms.games.SNAPSHOT_METADATA")) {
            return null;
        }
        SnapshotMetadata snapshotMetadata = (SnapshotMetadata)extras.getParcelable("com.google.android.gms.games.SNAPSHOT_METADATA");
        return snapshotMetadata;
    }

    private static abstract class DeleteImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.DeleteSnapshotResult> {
        private DeleteImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.DeleteSnapshotResult zzav(final Status status) {
            return new Snapshots.DeleteSnapshotResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public String getSnapshotId() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzav(x0);
        }
    }

    private static abstract class CommitImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.CommitSnapshotResult> {
        private CommitImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.CommitSnapshotResult zzau(final Status status) {
            return new Snapshots.CommitSnapshotResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public SnapshotMetadata getSnapshotMetadata() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzau(x0);
        }
    }

    private static abstract class OpenImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.OpenSnapshotResult> {
        private OpenImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.OpenSnapshotResult zzax(final Status status) {
            return new Snapshots.OpenSnapshotResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public Snapshot getSnapshot() {
                    return null;
                }

                @Override
                public String getConflictId() {
                    return null;
                }

                @Override
                public Snapshot getConflictingSnapshot() {
                    return null;
                }

                @Override
                public SnapshotContents getResolutionSnapshotContents() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzax(x0);
        }
    }

    private static abstract class LoadImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.LoadSnapshotsResult> {
        private LoadImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.LoadSnapshotsResult zzaw(final Status status) {
            return new Snapshots.LoadSnapshotsResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }

                @Override
                public SnapshotMetadataBuffer getSnapshots() {
                    return new SnapshotMetadataBuffer(DataHolder.zzbi(14));
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaw(x0);
        }
    }
}

