use strict;
use warnings;

package ParserGUI;

use HTMLParser;
use ConfigHandler;
use Tk;

sub new() {
    my $self  = {};
    $self->{"config"} = new ConfigHandler();
    $self->{"config"}->read();
    $self->{"ifname"} = $self->{"config"}->{"ifname"};
    $self->{"ofnametxt"} = $self->{"config"}->{"ofnametxt"};
    $self->{"ofnamebsl"} = $self->{"config"}->{"ofnamebsl"};
    bless($self);           # but see below
    return $self;
}

sub startGUI($) {
    my $self = shift;

    # Main Window
    $self->{"main"} = new MainWindow();

    #GUI Building Area

    $self->{"frame"} = $self->{"main"} -> Frame() -> pack();
    $self->{"frame"}->gridColumnconfigure(2, -minsize => 400);

    $self->{"ifname_label"} = $self->{"frame"} -> Label(-text => "HTML Datei") -> grid(-row=>1, -column=>1);
    $self->{"ifname_entry"} = $self->{"frame"} -> Entry(-textvariable => \$self->{"ifname"}) -> grid(-row=>1, -column=>2, -sticky => "nsew");
    $self->{"ifbutton"} = $self->{"frame"} -> Button(-text => "..",
                                                    -command => [$self => 'selectInfile'])
                                            -> grid(-row=>1, -column=>3);

    $self->{"ofnametxt_label"} = $self->{"frame"} -> Label(-text => "Objekt-Liste") -> grid(-row=>2, -column=>1);
    $self->{"ofnametxt_entry"} = $self->{"frame"} -> Entry(-textvariable => \$self->{"ofnametxt"}) -> grid(-row=>2, -column=>2, -sticky => "nsew");
    $self->{"ofbuttontxt"} = $self->{"frame"} -> Button(-text => "..",
                                                    -command => [$self => 'selectOutfileTXT'])
                                            -> grid(-row=>2, -column=>3);

    $self->{"ofnamebsl_label"} = $self->{"frame"} -> Label(-text => "BSL Template") -> grid(-row=>3, -column=>1);
    $self->{"ofnamebsl_entry"} = $self->{"frame"} -> Entry(-textvariable => \$self->{"ofnamebsl"}) -> grid(-row=>3, -column=>2, -sticky => "nsew");
    $self->{"ofbuttonbsl"} = $self->{"frame"} -> Button(-text => "..",
                                                    -command => [$self => 'selectOutfileBSL'])
                                            -> grid(-row=>3, -column=>3);

    $self->{"start"} = $self->{"main"} -> Button(-text => "Vollgas!",
                                                    -command => [$self => 'push_button'])
                                            -> pack();

    MainLoop;

}

#This is executed when the button is pressed
sub selectInfile($) {
    my $self = shift;

    my @types = (["HTML File", '.html', 'TEXT'],
                    ["All Files", "*"] );

    my $fname = $self->{"main"}->getOpenFile(-filetypes => \@types,
                                        -initialfile=> $self->{"ifname"},
                                        -defaultextension => '.html');

    if($fname) {
        $self->{"ifname"} = $fname;
    }
}
sub selectOutfileTXT($) {
    my $self = shift;

    my @types = (["TXT File", '.txt', 'TEXT'],
                    ["All Files", "*"] );

    my $fname = $self->{"main"}->getSaveFile(-filetypes => \@types,
                                        -initialfile=> $self->{"ofnametxt"},
                                        -defaultextension => '.txt');

    if($fname) {
        $self->{"ofnametxt"} = $fname;
    }
}
sub selectOutfileBSL($) {
    my $self = shift;

    my @types = (["BSL File", '.bsl', 'TEXT'],
                 ["TXT File", '.txt', 'TEXT'],
                    ["All Files", "*"] );

    my $fname = $self->{"main"}->getSaveFile(-filetypes => \@types,
                                        -initialfile=> $self->{"ofnamebsl"},
                                        -defaultextension => '.bsl');

    if($fname) {
        $self->{"ofnamebsl"} = $fname;
    }
}

#This is executed when the button is pressed
sub push_button($) {
    my $self = shift;

    print $self->{"ifname"}, "\n";

    HTMLParser::parseFile($self->{"ifname"});
    HTMLParser::writeTXT($self->{"ofnametxt"});
    HTMLParser::writeBSL($self->{"ofnamebsl"});
    $self->{"config"}->write($self->{"ifname"}, $self->{"ofnametxt"}, $self->{"ofnamebsl"});
    $self->{"main"} -> messageBox(-message=>"Fertig!",
		-type=>'ok',-icon=>'info');

}





1;
