use strict;
use warnings;

package ConfigHandler;

my @keys = qw[ifname1 ifname2 ifmask ifpad ifstart ifend animdelay animtype animvar animcomment objcount objblocking objvisible objontop objkilling lastdir lastext];

sub new() {
    my $self  = {};
    $self->{"ifname1"} = "test_00001.bmp";
    $self->{"ifname2"} = "test_00020.bmp";
    $self->{"ifmask"} = "";
    $self->{"ifpad"} = "";
    $self->{"ifstart"} = "";
    $self->{"ifend"} = "";
    $self->{"animdelay"} = "";
    $self->{"animtype"} = "Loop";
    $self->{"animvar"} = "GLOBAL.bla";
    $self->{"animcomment"} = "Super transparent 'bla'";
    $self->{"objcount"} = 1;
    $self->{"objblocking"} = 0;
    $self->{"objvisible"} = 0;
    $self->{"objontop"} = 0;
    $self->{"objkilling"} = 0;
    $self->{"lastext"} = ".bmp";

	# Check, if a dir called "C:\" exists, then we are on windows
	if(-d "C:\\") {
    	$self->{"configpath"} = "C:\\bs_animscripter.conf";
        $self->{"lastdir"} = "C:\\";
	} else {
    	$self->{"configpath"} = "~/.bs_animscripter.conf";
        $self->{"lastdir"} = "~";
	}




    bless($self);           # but see below
    return $self;
}

sub read($) {
  my $self = shift;

  if(open(my $fh, $self->{"configpath"})) {
      my @lines = <$fh>;
      foreach my $line (@lines) {
          chomp $line;
          if($line =~ /(.*)=(.*)/) {
            my ($key, $val) = ($1, $2);
            if(defined($self->{$key})) {
                $self->{$key} = $val;
            }
          }
      }
  }
}

sub write($) {
    my $self = shift;
#    foreach my $key (@keys) {
#        $self->{$key} = shift;
#    }
    open(my $fh, ">", $self->{"configpath"}) or return;
    foreach my $key (@keys) {
#        print "$key\n";
        print $fh "$key=" . $self->{$key} . "\n";
    }
    close($fh);
}

1;
