#include "globals.h"
#include "splash.h"
#include "errorhandler.h"
#include "drawprimitives.h"
#include "bsscreen.h"

void showSplash() {
/* SDL_putenv is defined in version 1.2, not in 1.1.8 (as far as I found out...), putenv()
   is probably not available => do the centering only if the SDL version is new enough. */
#if SDL_VERSION_ATLEAST(1, 2, 0)
#ifdef SDL_putenv
	SDL_putenv((char*) "SDL_VIDEO_CENTERED=1"); /* center the splash screen */
#endif // SDL_putenv
#endif
	gScreen = SDL_SetVideoMode(500, 300, 32, SDL_SWSURFACE | SDL_NOFRAME);
	drawrect(0, 0, 500, 300, 0xffffff);

	/* Load the splashscreen either from the $RESPATH, or the homedirectory, because the data might not be copied to the homedirectory */
    char fullfname[MAX_FNAME_LENGTH];
	sprintf(fullfname, "%s", configGetPath("splash.jpg"));
	SDL_Surface* temp;
	temp = IMG_Load(fullfname);
    if(!temp) {
        temp = IMG_Load(RESPATH "splash.jpg");
    }
	if(!temp) {
		DIE(ERROR_IMAGE_READ, RESPATH "splash.jpg");
	}

	SDL_Surface *temp2 = SDL_DisplayFormat(temp);
	SDL_FreeSurface(temp);

	SDL_BlitSurface(temp2, 0, gScreen, 0);
	BS_Flip(gScreen);
	SDL_FreeSurface(temp2);


}
