// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#include "globals.h"
#include "showloading.h"
#include "memops.h"
#include "errorhandler.h"
#include "drawprimitives.h"
#include "bsscreen.h"

SDL_Surface *LOADING_Surface;

void initShowLoading(const char *fname) {
	LOADING_Surface = BS_IMG_Load_DisplayFormat(configGetPath(fname),DIE_ON_FILE_ERROR);
}


void showLoading() {
	if(enableColor3D) {
		BS_Set3DMode(COLOR3D_NONE);
	}
	
	SDL_BlitSurface(LOADING_Surface, NULL, gScreen, NULL);

	// Tell SDL to update the whole screen
	BS_Flip(gScreen);

}

void deInitShowLoading() {
	SDL_FreeSurface(LOADING_Surface);
}
