// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#ifndef OSDEPS_H
#define OSDEPS_H
#include <SDL.h>
#include <SDL_image.h>
#include <math.h>

#ifndef DISABLE_SOUND
#include <SDL_mixer.h>
#endif

#ifdef __WIN32__
#define RESPATH ""
#endif // __WIN32__

#ifdef XCODE_DEVELOPMENT
#undef CAVAC_RELEASEMODE
#undef ENABLE_FULLSCREEN
#endif // XCODE_DEVELOPMENT

#ifdef __WIN32__
bool Win32_GetDocPath(char* docPath);
#endif // __WIN32__

// (hopefully) fixed the round()-Problem in various operating systems:
// 
// The round() - function is defined in the C99 Standard, floor in an older standard (C89)
// (see e.g. http://www.schweikhardt.net/identifiers.html)
// So if the compiler does not support C99, #define round(x) floor((x)+0.5)
// 
// The following C99-related defines are defined (in gcc):
// gcc  -E -dM test.cpp | grep C99
// #define __USING_NAMESPACE_C99(name)
// #define __USE_ISOC99 1
// #define _ISOC99_SOURCE 1
// #define __END_NAMESPACE_C99
// #define __BEGIN_NAMESPACE_C99

#ifndef __USE_ISOC99
#ifndef __WIN32
#ifndef round
#define round(x) floor((x)+0.5)
#endif // round
#ifndef lrint
#define lrint(x) ((long int)(floor(x+(x>0) ? 0.5 : -0.5)))
#endif // lrint
#endif // __WIN32
#endif // __USE_ISOC99


// unified mkdir macro for Unix and Windows and OLPC.
#ifdef __WIN32__
#define MKDIR(fname) _mkdir((fname))
#else // NO WIN32
#ifdef OLPCBUILD
// OLPC uses GROUP in addition to USER
#define MKDIR(fname) mkdir((fname), S_IRWXU | S_IRWXG)
#else // NO OLPC
#define MKDIR(fname) mkdir((fname), S_IRWXU)
#endif // NO OLPC
#endif // NO WIN32

#endif // OSDEPS_H
