// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#include "osdef.h"
#include "globals.h"

// OS-dependant code goes here

#ifdef __WIN32__

#include <windows.h>
#include <Shlobj.h>
#include <string>

bool Win32_GetDocPath(char* docPath)
{
	//IShellFolder *folder = 0;
	ITEMIDLIST *itemidlistptr = 0;
	IMalloc *alloc = 0;
	char szDocPath[MAX_PATH];

	SHGetSpecialFolderLocation(0, CSIDL_PERSONAL,
&itemidlistptr);

	SHGetPathFromIDList(itemidlistptr, szDocPath);

	if (!SUCCEEDED(SHGetMalloc(&alloc)))
	{
		return false;
	}

	alloc->Free(itemidlistptr);

	sprintf(docPath, "%s", szDocPath);

	return true;
}
#endif // __WIN32__
