#!/bin/bash
cd cmake-build &&
echo "Local pre-build cleanup" &&
rm -rf * &&
echo "Configuring" &&
CXXFLAGS+=-g cmake .. -DCMAKE_INSTALL_PREFIX:PATH=/home/olpc/Activities/LostPixels.activity -DIS_OLPC=ON -DOPTIMIZE=ON &&
echo "Building" &&
make &&
echo "Removing installed Activity" &&
su -c "rm -rf /home/olpc/Activities/LostPixels.activity" &&
echo "Installing Activity Framework" &&
su -c "cp -r ../OLPC/LostPixels.activity /home/olpc/Activities" &&
echo "Installing binaries and data files" &&
su -c "make install" &&
echo "Updating rights" &&
su -c "chown -R olpc:olpc /home/olpc/Activities/LostPixels.activity" &&
echo "Cleaning up temp files in install dir" &&
su -c "find /home/olpc/Activities/LostPixels.activity -type d | grep .svn | xargs rm -rf" &&
echo "Striping unneeded symbols from binaries" &&
su -c "find /home/olpc/Activities/LostPixels.activity/bin -type f | grep -v .sh | xargs -n 1 strip"
echo Build and install finished
