// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#include "globals.h"
#include "menu.h"
#include "fonthandler.h"
#include "errorhandler.h"
#include "memops.h"
#include "sound.h"
#include "joystick.h"
#include "showvideo.h"
#include <string.h>
#include "httpclient.h"
#include "drawprimitives.h"
#include "blending.h"
#include "extractmetabmf.h"
#include "gameengine.h"
#include "intro.h"
#include "engine.h"
#include "bsgui.h"
#include "oggplayer.h"
#include "showloading.h"
#include "bsscreen.h"

SDL_Surface* menubg = 0;
SDL_Surface* menuonlinebg = 0;

bool menuIsVideoTest = false;
Uint32 attrackModeType = 0;

SDL_Color MENUCOLOR_ACTIVE   = { 0xff, 0xff, 0xff, 0 };
SDL_Color MENUCOLOR_INACTIVE = { 0xa0, 0xa0, 0xa0, 0 };

#ifndef DISABLE_NETWORK
extern char * proxyurl ;
#endif // DISABLE_NETWORK

void initMenu() {
	menubg = BS_IMG_Load_DisplayFormat(configGetPath("menubg.jpg"),DIE_ON_FILE_ERROR) ;
	menuonlinebg = BS_IMG_Load_DisplayFormat(configGetPath("menuonlinebg.jpg"),DIE_ON_FILE_ERROR);
}

void deInitMenu() {
	SDL_FreeSurface(menubg);
	SDL_FreeSurface(menuonlinebg);
	menubg = 0;
}

bool menuDisplay() {
#ifdef BLINKOMATEDITION
//	menuAttrackMode();
//	return true;
#endif // BLINKOMATEDITION

	const char* menutexte[] = {"Play",
#ifndef DISABLE_NETWORK
                                    "Download",
#endif // DISABLE_NETWORK
                                               "Contribute","Quit", NULL};

	Uint32 sel = 1;
	Uint32 max = sizeof(menutexte)/sizeof(menutexte[0])-1;
	if(menuIsVideoTest) {
		max = 6;
	}
	bool menuRunning = true;
	bool joystickIdle = false;

	soundStartMusic("ADDON/LostPixels/menuMusic.ogg", true);
	while(menuRunning) {

		SDL_BlitSurface(menubg, NULL, gScreen, NULL);

		Uint32 cnt=0;
		while(menutexte[cnt] != NULL) {
			if ((cnt+1)==sel) {
				char s[255];
				sprintf(s,"* %s *",menutexte[cnt]);
				renderFontHandlerText(10, 100+cnt*70, s, MENUCOLOR_ACTIVE, true, false, FONT_menufont_50); /* selected */
			} else {
				renderFontHandlerText(10, 100+cnt*70, menutexte[cnt], MENUCOLOR_INACTIVE, true, false, FONT_menufont_50); /* not selected */
			}
			cnt++ ;
		}
		renderFontHandlerText(30, 440, "Version: " VERSION, MENUCOLOR_INACTIVE, false, false, FONT_menufont_20);

		BS_Flip(gScreen); /* Update whole screen */

		// Handle Joystick
		Uint32 joymove = getJoystickMoves();
		if(joymove == JOYSTICK_NONE) {
			joystickIdle = true;
		}
		if(joystickIdle && joymove != JOYSTICK_NONE) {
			if((joymove & JOYSTICK_UP)) {
				soundPlayFX(FX_MENU);
				sel--;
				if(!sel) {
					sel = max;
				}
			} else if((joymove & JOYSTICK_DOWN)) {
				soundPlayFX(FX_MENU);
				sel++;
				if(sel > max) {
					sel = 1;
				}
			} else if((joymove & JOYSTICK_ACTION)) {
				// FIXME: Handle CONFIGURE option
				soundPlayFX(FX_MENU);
				if(strcmp(menutexte[sel-1],"Contribute")==0) {
					menuShowNeedHelp();
#ifndef DISABLE_NETWORK
				} else if(strcmp(menutexte[sel-1],"Download")==0) {
					menuOnlineDisplay();
#endif // DISABLE_NETWORK
				} else if(strcmp(menutexte[sel-1],"Play")==0) {
					menuAddonDisplay();
				} else {
                    if(guiYesNoDialog("Do you really want to", "quit BlinkenSisters?", true)) {
					   menuRunning = false;
                    }
				}			}
			joystickIdle = false;
		}


		// Handle Keyboard
		SDL_Event event;
		while (SDL_PollEvent(&event))
		{
			switch (event.type)
			{
				case SDL_KEYUP:
					if ((event.key.keysym.sym == SDLK_UP) ||(event.key.keysym.sym == SDLK_w)) {
						soundPlayFX(FX_MENU);
						sel--;
						if(!sel) {
							sel = max;
						}
					} else if ((event.key.keysym.sym == SDLK_DOWN) ||(event.key.keysym.sym == SDLK_s)) {
						soundPlayFX(FX_MENU);
						sel++;
						if(sel > max) {
							sel = 1;
						}
					} else if (event.key.keysym.sym == SDLK_RETURN) {
						// FIXME: Handle CONFIGURE option
						soundPlayFX(FX_MENU);
						if(strcmp(menutexte[sel-1],"Contribute")==0) {
							menuShowNeedHelp();
#ifndef DISABLE_NETWORK
						} else if(strcmp(menutexte[sel-1],"Download")==0) {
							menuOnlineDisplay();
#endif // DISABLE_NETWORK
						} else if(strcmp(menutexte[sel-1],"Play")==0) {
							menuAddonDisplay();
						} else {
                            if(guiYesNoDialog("Do you really want to", "quit BlinkenSisters?", true)) {
							     menuRunning = false;
                            }
						}
#ifdef ALLOW_BOSSKEY
					} else if (event.key.keysym.sym == SDLK_ESCAPE) {
						displaymessage(displaymessage_INFO, "Boss-key (ESC) hit - fast exit", 800);
						exit(0);
#endif // ALLOW_BOSSKEY
					}

					break;
			}
		}

		// Check for "Attrack mode"
		if(soundPlayOnceFinished()) {
			menuAttrackMode();
		}

		SDL_Delay(50);
	}

	if(!menuIsVideoTest) {
		soundStopMusic();
	}

	return false;
}

#ifndef DISABLE_NETWORK

// -------- ONLINE DISPLAY ---------------------
struct WEBTOC {
	char name[100];
	char desc[100];
	char size[10];
	char fname[100];
};

bool menuOnlineDisplay() {

	//SDL_Color MENUCOLOR_ACTIVE   = { 0xaf, 0xff, 0xff, 0 };
	//SDL_Color MENUCOLOR_INACTIVE = { 0x40, 0xa0, 0xa0, 0 };
	//SDL_Color MENUCOLOR_INACTIVE = { 0x70, 0x70, 0x70, 0 };

	// -- Prepare http client and download TOC -> display a progress bar --
	char httpfile[1000];
	WEBTOC files[100];

	SDL_BlitSurface(menuonlinebg, NULL, gScreen, NULL);

	renderFontHandlerText(10, 100, "Please wait...", MENUCOLOR_ACTIVE, true, false, FONT_menufont_50);

	BS_Flip(gScreen); /* Update whole screen */


	sprintf(httpfile, "%s%s", HTTPBASEDIR, HTTPTOCFILE);
	HTTPClient web(HTTPSERVER, HTTPPORT, HTTPDEBUG, proxyurl);
	/* BASIC network test - did DNS resolve work? If not, skip the rest of the download menu.
	   This test is not enough - for example nscd or something else might have the IP
	   in a cache, even if the network is down, there is no test, if the host is reachable - but better than nothing... */
	if (web.networkstatus() == false) {return false ; } ; 
	if(!web.get(httpfile)) {
		DIE(ERROR_HTTPGET, httpfile);
	}
	if(!web.save(configGetPath("temp_webtoc"))) {
		DIE(ERROR_FILE_WRITE, configGetPath("temp_webtoc"));
	}


	Uint32 sel = 1;
	Uint32 offs = 1;
	Uint32 max = 0; /* TODO: compute max as the size of the array menutexte */
	FILE *toc = fopen(configGetPath("temp_webtoc"), "r");
	if(!toc) {
		DIE(ERROR_FILE_READ, configGetPath("temp_webtoc"));
	}
	char line[1001];
	char* tmpchar;
	char* tmpchar2;
	while(!feof(toc)) {
		max++;
		if(!fgets(line, 1000, toc)) {
			break;
		}
		while((tmpchar = strchr(line, '\n'))) {
			*tmpchar = 0;
		}
		while((tmpchar = strchr(line, '\r'))) {
			*tmpchar = 0;
		}


		if(!(tmpchar = strchr(line, '|'))) {
			DIE(ERROR_HTTPTOC, "1|2");
		}
		*tmpchar = 0;
		sprintf(files[max].name, "%s", line);
		tmpchar++;
		tmpchar2 = tmpchar;

		if(!(tmpchar = strchr(tmpchar, '|'))) {
			DIE(ERROR_HTTPTOC, "2|3");
		}
		*tmpchar = 0;
		sprintf(files[max].desc, "%s", tmpchar2);
		tmpchar++;
		tmpchar2 = tmpchar;

		if(!(tmpchar = strchr(tmpchar, '|'))) {
			DIE(ERROR_HTTPTOC, "3|4");
		}
		*tmpchar = 0;
		sprintf(files[max].size, "%s", tmpchar2);
		tmpchar++;
		tmpchar2 = tmpchar;
		sprintf(files[max].fname, "%s", tmpchar2);
	}
	fclose(toc);

	bool menuRunning = true;
	bool joystickIdle = false;
	while(menuRunning) {
		SDL_BlitSurface(menuonlinebg, NULL, gScreen, NULL);

		// Scroll to the correct position
		while( ((Sint32)sel - (Sint32)offs) > 3) {
			offs++;
		}
		while( ((Sint32)sel - (Sint32)offs) < 0) {
			offs--;
		}

		Uint32 tmpmax = max;
		if(tmpmax > (offs + 3)) {
			tmpmax = offs + 3;
		}

		for(Uint32 i= offs; i <= tmpmax; i++) {
			int my_y = 70+(i - offs) *90;

			if(i < max) {
				blend_darkenRect(20, my_y, 600, 80, 0x00a0a0a0);
				if(i == sel) {
					drawrect(20, my_y, 600, 1, 0xd0d0d0);
					drawrect(20, my_y, 1, 80, 0xd0d0d0);
					drawrect(20, my_y+79, 600, 1, 0xd0d0d0);
					drawrect(619, my_y, 1, 80, 0xd0d0d0);
				} else {
					drawrect(20, my_y, 600, 1, 0x606060);
					drawrect(20, my_y, 1, 80, 0x606060);
					drawrect(20, my_y+79, 600, 1, 0x606060);
					drawrect(619, my_y, 1, 80, 0x606060);
				}
			}

			if(i == max) {
				if(i == sel) {
					renderFontHandlerText(10, my_y + 10, "Back", MENUCOLOR_ACTIVE, true, false, FONT_menufont_50);
				} else {
					renderFontHandlerText(10, my_y + 10, "Back", MENUCOLOR_INACTIVE, true, false, FONT_menufont_50);
				}
			} else {
				if(i == sel) {
					renderFontHandlerText(23, my_y + 3, files[i].name, MENUCOLOR_ACTIVE, false, false, FONT_menufont_50);
					renderFontHandlerText(23, my_y + 57, files[i].desc, MENUCOLOR_ACTIVE, false, false, FONT_menufont_20);
					renderFontHandlerText(520, my_y + 57, files[i].size, MENUCOLOR_ACTIVE, false, false, FONT_menufont_20);
				} else {
					renderFontHandlerText(23, my_y + 3, files[i].name, MENUCOLOR_INACTIVE, false, false, FONT_menufont_50);
					renderFontHandlerText(23, my_y + 57, files[i].desc, MENUCOLOR_INACTIVE, false, false, FONT_menufont_20);
					renderFontHandlerText(520, my_y + 57, files[i].size, MENUCOLOR_INACTIVE, false, false, FONT_menufont_20);
				}
			}


		}

		BS_Flip(gScreen); /* Update whole screen */

		// Handle Joystick
		Uint32 joymove = getJoystickMoves();
		if(joymove == JOYSTICK_NONE) {
			joystickIdle = true;
		}
		if(joystickIdle && joymove != JOYSTICK_NONE) {
			if((joymove & JOYSTICK_UP)) {
				soundPlayFX(FX_MENU);
				sel--;
				if(!sel) {
					sel = max;
				}
			} else if((joymove & JOYSTICK_DOWN)) {
				soundPlayFX(FX_MENU);
				sel++;
				if(sel > max) {
					sel = 1;
				}
			} else if((joymove & JOYSTICK_ACTION)) {
				// FIXME: Handle CONFIGURE option
				soundPlayFX(FX_MENU);
				if(sel != max) {
    				if(guiYesNoDialog("Download AddOn?", files[sel].name, true)) {
        				soundPlayFX(FX_MENU);

    					sprintf(httpfile, "%s%s", HTTPBASEDIR, files[sel].fname);
    					if(!web.get(httpfile)) {
    						DIE(ERROR_HTTPGET, httpfile);
    					}
    					if(!web.save(configGetPath("temp_web.bmf"))) {
    						DIE(ERROR_FILE_WRITE, configGetPath("temp_web.bmf"));
    					}
    					if(!extractMetaBMF(configGetPath("temp_web.bmf"))) {
    						DIE(ERROR_BMFPARSE, configGetPath("temp_web.bmf"));
    					}
    					soundPlayFX(FX_MENU);
                    }
				} else {
					menuRunning = false;
				}
			}
			joystickIdle = false;
		}


		// Handle Keyboard
		SDL_Event event;
		while (SDL_PollEvent(&event))
		{
			switch (event.type)
			{
				case SDL_KEYUP:
					if ((event.key.keysym.sym == SDLK_UP) || (event.key.keysym.sym == SDLK_w)) {
						soundPlayFX(FX_MENU);
						sel--;
						if(!sel) {
							sel = max;
						}
					} else if ((event.key.keysym.sym == SDLK_DOWN) || (event.key.keysym.sym == SDLK_s)) {
						soundPlayFX(FX_MENU);
						sel++;
						if(sel > max) {
							sel = 1;
						}
					} else if (event.key.keysym.sym == SDLK_RETURN) {
						// FIXME: Handle CONFIGURE option
						soundPlayFX(FX_MENU);
						if(sel != max) {
                            if(guiYesNoDialog("Download AddOn?", files[sel].name, true)) {
                                soundPlayFX(FX_MENU);
    							sprintf(httpfile, "%s%s", HTTPBASEDIR, files[sel].fname);
    							if(!web.get(httpfile)) {
    								DIE(ERROR_HTTPGET, httpfile);
    							}
    							if(!web.save(configGetPath("temp_web.bmf"))) {
    								DIE(ERROR_FILE_WRITE, configGetPath("temp_web.bmf"));
    							}
    							if(!extractMetaBMF(configGetPath("temp_web.bmf"))) {
    								DIE(ERROR_BMFPARSE, configGetPath("temp_web.bmf"));
    							}
    							soundPlayFX(FX_MENU);
                            }
						} else {
							menuRunning = false;
						}
#ifdef ALLOW_BOSSKEY
					} else if (event.key.keysym.sym == SDLK_ESCAPE) {
						exit(0);
#endif // ALLOW_BOSSKEY
					}

					break;
			}
		}

		SDL_Delay(50);
	}

	return true;
}
#endif // DISABLE_NETWORK


// -------- ADDON DISPLAY ---------------------
struct ADDONTOC {
	char name[100];
	char desc[100];
	char fname[100];
};

bool menuAddonDisplay() {

	ADDONTOC files[100];

	Uint32 sel = 1;
	Uint32 offs = 1;
	Uint32 max = 0; /* TODO: compute max as the size of the array menutexte */
	FILE *toc = fopen(configGetPath("addons.dat"), "r");
	if(!toc) {
		//DIE(ERROR_FILE_READ, configGetPath("addons.dat"));
		max = 1;
	} else {
		char line[1001];
		char* tmpchar;
		char* tmpchar2;
		while(!feof(toc)) {
			max++;
			if(!fgets(line, 1000, toc)) {
				break;
			}
			while((tmpchar = strchr(line, '\n'))) {
				*tmpchar = 0;
			}
			while((tmpchar = strchr(line, '\r'))) {
				*tmpchar = 0;
			}


			if(!(tmpchar = strchr(line, '|'))) {
				DIE(ERROR_HTTPTOC, "1|2");
			}
			*tmpchar = 0;
			sprintf(files[max].name, "%s", line);
			tmpchar++;
			tmpchar2 = tmpchar;

			if(!(tmpchar = strchr(tmpchar, '|'))) {
				DIE(ERROR_HTTPTOC, "2|3");
			}
			*tmpchar = 0;
			sprintf(files[max].desc, "%s", tmpchar2);
			tmpchar++;
			tmpchar2 = tmpchar;

			sprintf(files[max].fname, "%s", tmpchar2);
		}
		fclose(toc);
	}

	bool menuRunning = true;
	bool joystickIdle = false;

	while(menuRunning) {

		SDL_BlitSurface(menuonlinebg, NULL, gScreen, NULL);

		// Scroll to the correct position
		while( ((Sint32)sel - (Sint32)offs) > 3) {
			offs++;
		}
		while( ((Sint32)sel - (Sint32)offs) < 0) {
			offs--;
		}

		Uint32 tmpmax = max;
		if(tmpmax > (offs + 3)) {
			tmpmax = offs + 3;
		}

		for(Uint32 i= offs; i <= tmpmax; i++) {
			int my_y = 70+(i - offs) *90;

			if(i < max) {
				blend_darkenRect(20, my_y, 600, 80, 0x00a0a0a0);
				if(i == sel) {
					drawrect(20, my_y, 600, 1, 0xd0d0d0);
					drawrect(20, my_y, 1, 80, 0xd0d0d0);
					drawrect(20, my_y+79, 600, 1, 0xd0d0d0);
					drawrect(619, my_y, 1, 80, 0xd0d0d0);
				} else {
					drawrect(20, my_y, 600, 1, 0x606060);
					drawrect(20, my_y, 1, 80, 0x606060);
					drawrect(20, my_y+79, 600, 1, 0x606060);
					drawrect(619, my_y, 1, 80, 0x606060);
				}
			}

			if(i == max) {
				if(i == sel) {
					renderFontHandlerText(10, my_y + 10, "Back", MENUCOLOR_ACTIVE, true, false, FONT_menufont_50);
				} else {
					renderFontHandlerText(10, my_y + 10, "Back", MENUCOLOR_INACTIVE, true, false, FONT_menufont_50);
				}
			} else {
				if(i == sel) {
					renderFontHandlerText(23, my_y + 3, files[i].name, MENUCOLOR_ACTIVE, false, false, FONT_menufont_50);
					renderFontHandlerText(23, my_y + 57, files[i].desc, MENUCOLOR_ACTIVE, false, false, FONT_menufont_20);
				} else {
					renderFontHandlerText(23, my_y + 3, files[i].name, MENUCOLOR_INACTIVE, false, false, FONT_menufont_50);
					renderFontHandlerText(23, my_y + 57, files[i].desc, MENUCOLOR_INACTIVE, false, false, FONT_menufont_20);
				}
			}


		}

		BS_Flip(gScreen); /* Update whole screen */

		// Handle Joystick
		Uint32 joymove = getJoystickMoves();
		if(joymove == JOYSTICK_NONE) {
			joystickIdle = true;
		}
		if(joystickIdle && joymove != JOYSTICK_NONE) {
			if((joymove & JOYSTICK_UP)) {
				soundPlayFX(FX_MENU);
				sel--;
				if(!sel) {
					sel = max;
				}
			} else if((joymove & JOYSTICK_DOWN)) {
				soundPlayFX(FX_MENU);
				sel++;
				if(sel > max) {
					sel = 1;
				}
			} else if((joymove & JOYSTICK_ACTION)) {
				// FIXME: Handle CONFIGURE option
				soundPlayFX(FX_MENU);
				if(sel != max) {
					soundStopMusic();
					configSetAddOn(files[sel].fname);
					initGame();
					playGame();
					configResetAddOn();
					soundStartMusic("ADDON/LostPixels/menuMusic.ogg");
				} else {
					menuRunning = false;
				}
			}
			joystickIdle = false;
		}


		// Handle Keyboard
		SDL_Event event;
		while (SDL_PollEvent(&event))
		{
			switch (event.type)
			{
				case SDL_KEYUP:
					if ((event.key.keysym.sym == SDLK_UP) || (event.key.keysym.sym == SDLK_w)) {
						soundPlayFX(FX_MENU);
						sel--;
						if(!sel) {
							sel = max;
						}
					} else if ((event.key.keysym.sym == SDLK_DOWN) ||(event.key.keysym.sym == SDLK_s)) {
						soundPlayFX(FX_MENU);
						sel++;
						if(sel > max) {
							sel = 1;
						}
					} else if (event.key.keysym.sym == SDLK_RETURN) {
						soundPlayFX(FX_MENU);
						if(sel != max) {
							soundStopMusic();
							configSetAddOn(files[sel].fname);
							initGame();
							playGame();
							configResetAddOn();
							soundStartMusic("ADDON/LostPixels/menuMusic.ogg");
						} else {
							menuRunning = false;
						}
#ifdef ALLOW_BOSSKEY
					} else if (event.key.keysym.sym == SDLK_ESCAPE) {
						displaymessage(displaymessage_INFO, "Boss-key (ESC) hit - fast exit", 800);
						exit(0);
#endif // ALLOW_BOSSKEY
					}

					break;
			}
		}

		// Check for "Attrack mode"
		if(soundPlayOnceFinished()) {
			menuAttrackMode();
		}

		SDL_Delay(50);
	}

	return true;
}

void menuShowNeedHelp() {
	SDL_Color BS_Color_RED   = { 0xff, 0x00, 0x00, 0 };
	SDL_Color BS_Color_WHITE   = { 0xff, 0xff, 0xff, 0 };
	SDL_BlitSurface(menubg, NULL, gScreen, NULL);
	blend_darkenRect(50, 50, SCR_WIDTH - 100, SCR_HEIGHT - 100, 0x00303030);
	renderFontHandlerText(SCR_WIDTH / 2,100, "We need your help!", BS_Color_RED, true, false, FONT_menufont_30);
	renderFontHandlerText(70, 140, "Blinkensisters needs more levels\ngraphics, movies, story,\ndocumentation and - fun, of course.\n\nContact the Blinkensisters team:\n<team@blinkensisters.org>\nVisit our website at:\nhttp://www.blinkensisters.org", BS_Color_WHITE, false, false, FONT_textfont_30);
	BS_Flip(gScreen); /* Update whole screen */

	bool joystickIdle = false;
	while(1) {
		SDL_Delay(50);

		// Handle Keyboard
		SDL_Event event;
		while (SDL_PollEvent(&event))
		{
			switch (event.type)
			{
				case SDL_KEYUP:
					soundPlayFX(FX_MENU);
					return;
			}
		}
		Uint32 joymove = getJoystickMoves();
		if(joymove == JOYSTICK_NONE) {
			joystickIdle = true;
		} else if(joystickIdle) {
			soundPlayFX(FX_MENU);
			return;
		}
	}
}

void menuPerformanceTestMode() {
	soundStopMusic();
	attracktModeRunning = true;
	gamedata.player = &gamedata.players[0];
	gamedata.player->level = 1;
	gamedata.player->score = 0;
	gamedata.player->lives = 100;
	configSetAddOn("LostPixels");
	showLoading();
	initEngine(true);
	displayEngine("poscap_level_1.bin");
	deInitEngine();
	gamedata.player->level = 2;
	gamedata.player->score = 0;
	gamedata.player->lives = 100;
	showLoading();
	initEngine(true);
	displayEngine("poscap_level_2.bin");
	deInitEngine();
	gamedata.player = &gamedata.players[0];
	gamedata.player->level = 3;
	gamedata.player->score = 0;
	gamedata.player->lives = 100;
	showLoading();
	initEngine(true);
	displayEngine("poscap_level_3.bin");
	deInitEngine();
	configResetAddOn();
}

void menuAttrackMode() {
	soundStopMusic();

	attracktModeRunning = true;
	attrackModeType = 0;
	while(attracktModeRunning) {
		switch(attrackModeType) {
			case 0:
				configSetAddOn("LostPixels");
				displayIntro();
				configResetAddOn();
				break;
			case 1:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 1;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_1.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 2:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 2;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_2.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 3:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 3;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_3.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 4:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 4;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_4.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 5:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 5;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_5.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 6:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 6;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_6.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 7:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 7;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_7.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 8:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 8;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_8.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 9:
				configSetAddOn("LostPixels");
				displayIntro();
				configResetAddOn();
				break;
			case 10:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 9;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_9.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 11:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 10;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_10.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 12:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 11;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_11.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 13:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 12;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_12.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 14:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 13;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_13.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 15:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 14;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_14.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 16:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 15;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_15.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 17:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 16;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_16.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 18:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 17;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_17.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 19:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 18;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_18.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 20:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 19;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_19.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 21:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 20;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_20.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 22:
				gamedata.player = &gamedata.players[0];
				gamedata.player->level = 21;
				gamedata.player->score = 0;
				gamedata.player->lives = 2;
				configSetAddOn("LostPixels");
				showLoading();
				initEngine(true);
				displayEngine("poscap_level_21.bin");
				deInitEngine();
				configResetAddOn();
				break;
			case 23:
#ifdef HASOGGSUPPORT
				playogg("startanim_video.ogg",gScreen); /* play the standard ogg video instead of the BMF showVideo("startanim.bmf", true); */
#else // HASOGGSUPPORT
				showVideo("startanim.bmf", true, true);
#endif // NO HASOGGSUPPORT
				break;
		}
		attrackModeType++;
		if(attrackModeType == 23) {
			attrackModeType = 0;
		}
	}
	soundStartMusic("ADDON/LostPixels/menuMusic.ogg", true);
}
