#include "globals.h"

#ifndef MCUFFRAMES_H
#define MCUFFRAMES_H

#ifndef DISABLE_NETWORK

#define MCUFSCR_M 0
#define MCUFSCR_H 8
#define MCUFSCR_W 18
#define MCUFSCR_CHANS 3

#define MCUFKATE_X 9
#define MCUFKATE_Y 3

#define MCUF_XOFFSET TILESIZE/2
#define MCUF_YOFFSET TILESIZE*3.0/4.0

#include <SDL_net.h>

struct MCUF_Frame {
	char magic[4];
	char height[2];
	char width[2];
	char channels[2];
	char maxval[2];
	char pixels[432]; // currently fixed (3chans a 144 px)
};

void initMCUFSocket();
void deInitMCUFSocket();
void initMCUFFrames();
void deInitMCUFFrames();
void sendMCUFFrame();
void clearMCUFFrame();
void calculateNextWTC();
void showMCUFTiles();
void showMCUFFgObjects();
void showMCUFPixels();
void showMCUFMonster();
void initMCUFMovie(const char* filename);
bool showMCUFMovie();
void deInitMCUFMovie();

extern MCUF_Frame currentMCUFFrame;
extern Uint32 currentMCUFFrameNum;

extern UDPsocket MCUFsd;
extern UDPpacket *MCUFp;
#endif // DISABLE_NETWORK

#endif // MCUFFRAMES_H
