// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#include "globals.h"
#include "joystick.h"

// Pointer to the joystick interface
SDL_Joystick *gJoystick = NULL;
bool actionPressed = false;
bool jumpPressed = false;
bool pausePressed = false;

void initJoystick()
{
	if (SDL_NumJoysticks() > 0)
	{
		gJoystick = SDL_JoystickOpen(0);
		printf("Defined Joystick is: %s\n",USB_JOY_NAME);
		printf("Joystick found....\n");
		printf("JoystickName: %s\n",SDL_JoystickName(0));
		printf("NumAxes: %d\n",SDL_JoystickNumAxes(gJoystick));
		printf("NumBalls: %d\n",SDL_JoystickNumBalls(gJoystick));
		printf("NumHats: %d\n",SDL_JoystickNumHats(gJoystick));
		printf("NumNumButtons: %d\n",SDL_JoystickNumButtons(gJoystick));
		if (SDL_JoystickNumAxes(gJoystick) < 2)
		{
			// Not enough axes for our use; don't use the joystick.
			printf("Not enough axes for our use; don't use the joystick.\n");
			SDL_JoystickClose(gJoystick);
			gJoystick = NULL;
		}
	}
	return;
}

void deInitJoystick() 
{
	if (gJoystick) {
		SDL_JoystickClose(gJoystick);
		gJoystick = NULL;
	}
	return;
}

Uint32 getJoystickMoves() {
	Uint32 joymove = JOYSTICK_NONE;
	if(!gJoystick) {
		return joymove;
	}
	
	// Axis are between -32768 and +32768 for analog and digital joysticks. As we just want to check if the
	// player wants to move, we use pseudo-values of about 1/3 of the axis for triggering the move (on analog joysticks relevant only)
	Sint32 xmov = SDL_JoystickGetAxis(gJoystick, 0);
	Sint32 ymov = SDL_JoystickGetAxis(gJoystick, 1);
	
	if(xmov < USB_JOY_LOWER || (SDL_JoystickNumButtons(gJoystick)>(USB_JOY_LEFT+1) && SDL_JoystickGetButton(gJoystick, USB_JOY_LEFT))) {
		joymove += JOYSTICK_LEFT;
	} else if(xmov > USB_JOY_UPPER || (SDL_JoystickNumButtons(gJoystick)>(USB_JOY_RIGHT+1) && SDL_JoystickGetButton(gJoystick, USB_JOY_RIGHT))) {
		joymove += JOYSTICK_RIGHT;
	}
	
	if(ymov < USB_JOY_LOWER || (SDL_JoystickNumButtons(gJoystick)>(USB_JOY_UP+1) && SDL_JoystickGetButton(gJoystick, USB_JOY_UP))) {
		joymove += JOYSTICK_UP;
	} else if(ymov > USB_JOY_UPPER || (SDL_JoystickNumButtons(gJoystick)>(USB_JOY_DOWN+1) && SDL_JoystickGetButton(gJoystick, USB_JOY_DOWN))) {
		joymove += JOYSTICK_DOWN;
	}
	
	if(SDL_JoystickNumButtons(gJoystick)>(USB_JOY_JUMP+1) && SDL_JoystickGetButton(gJoystick, USB_JOY_JUMP)) {
		if(!jumpPressed) {
			joymove = joymove | JOYSTICK_JUMP;
			jumpPressed = true;
		}
	} else {
		jumpPressed = false;
	}
	if(SDL_JoystickNumButtons(gJoystick)>(USB_JOY_ACTION+1) && SDL_JoystickGetButton(gJoystick, USB_JOY_ACTION)) {
		if(!actionPressed) {
			joymove = joymove | JOYSTICK_ACTION;
			actionPressed = true;
		}
	} else {
		actionPressed = false;
	}
	
	if(SDL_JoystickNumButtons(gJoystick)>(USB_JOY_PAUSE+1) && SDL_JoystickGetButton(gJoystick, USB_JOY_PAUSE)) {
		if(!pausePressed) {
			joymove = joymove | JOYSTICK_PAUSE;
			pausePressed = true;
		}
	} else {
		pausePressed = false;
	}
	
	if(SDL_JoystickNumButtons(gJoystick)>(USB_JOY_TURBO+1) && SDL_JoystickGetButton(gJoystick, USB_JOY_TURBO)) {
		joymove = joymove | JOYSTICK_TURBO;
	}

	
	return joymove;
}

