// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See LICENSE for licensing information

// This file defines the globals as external variables
// The globals are declared and initialized in their respective program parts
//


#ifndef GLOBALS_H
#define GLOBALS_H


/* Version number *must* include the '"' (since we use version 'numbers' like "0.5.2" it is not really a number) */

#define VERSION "0.5.3"

/* What is the name of the Blinkensisters/Lostpixels directory? */
#ifdef __WIN32__
#define PROGRAMDIRECTORY "BlinkenSisters"
#else
#ifdef OLPCBUILD
#define PROGRAMDIRECTORY "lostpixels"
#else
#define PROGRAMDIRECTORY ".lostpixels"
#endif
#endif

// Special CD Edition?
#define CDEDITION

// Running on Blink-O-Mat
//#define BLINKOMATEDITION

// RELEASEMODE = less debug info, show intro
#define CAVAC_RELEASEMODE

// FULLSCREEN?
#ifndef CODEBLOCKS_DEBUG
#define ENABLE_FULLSCREEN
#endif // CODEBLOCKS_DEBUG
#define START_WITH_FULLSCREEN

// SHOW FPS?
#define SHOWFRAMERATE

// Allow cheats?
#define ALLOW_CHEATCODES
#define CHEATCODECHARS "abcdefghijklmnopqrstuvwxyz0123456789 "

#define NAMECODECHARS "abcdefghijklmnopqrstuvwxyz0123456789 "

// Display player coordinates?
#define DISPLAY_PLAYERCOORDS

// Allow ActionCapture
//#define ALLOW_ACTIONCAPTURE
#ifdef ALLOW_ACTIONCAPTURE
#define ACTIONCAPTURE_MAX 200
#define ACTIONCAPTURE_DELAY 100
#define ACTIONCAPTURE_HEIGHT 192
#define ACTIONCAPTURE_WIDTH 256
#endif

// Allow Position-capturing for Attrack-mode
//#define ALLOW_POSITIONCAPTURE

// Allow Bosskey (ESC is instant quit)
#define ALLOW_BOSSKEY

// Select USB JOYPAD
#define STD_USB_JOY_PAD
//#define TRUSTMASTER_FIRESTORM_JOY_PAD
//#define TRUSTMASTER_WIRELESS_JOY_PAD
//#define TRUST_USB_STEERING_WHEEL

// New colission detection?
//#define USE_NEWCOLDETECT

// Disable sound?
//#define DISABLE_SOUND

// Disable networking?
//#define DISABLE_NETWORK

// Include SDL and helpers
#include <stdlib.h>
#include <math.h>
#include "osdef.h"
#include "config.h"

// PATH TO RESOURCES
#ifndef RESPATH
#ifdef CAVAC_RELEASEMODE
#define RESPATH ""
#else // NO RELEASE
#define RESPATH "/Users/cavac/src/xcode/BlinkGame/LostPixels/lostpixels/game/software/build/Development/LostPixels.app/Contents/Resources/"
#endif // RELEASEMODE
#endif // RESPATH

// Webserver Paths
#ifdef ADDONTEST
#define HTTPSERVER "localhost"
#endif

#ifndef HTTPSERVER
#define HTTPSERVER "addon.blinkensisters.org"
#define HTTPBASEDIR "/V" VERSION "/"
#endif // NO HTTPSERVER
#define HTTPPORT 80
#define HTTPTOCFILE "toc"
#define HTTPDEBUG true

extern char * proxyurl ;

// Screen
#ifndef __OGGPLAYER
#ifndef OLPCBUILD
#define SCR_WIDTH 640
#define SCR_HEIGHT 480
#else // OLPCBUILD
#define SCR_WIDTH 600
#define SCR_HEIGHT 450
#endif // OLPCBUILD
#else // OGGPLAYER
#define SCR_WIDTH 400
#define SCR_HEIGHT 240
#endif
#define TILESIZE 32 // a tile is TILESIZE pixels wide and high

// Physics iterations per second
#define PHYSICSFPS 100
#define BLINKSPEED 2
#define SPECIALTILEDELAY 50

// Player movements
#define SPRITE_SWITCHWAIT 100
#define SPRITE_MAXSPEED 5
#define SPRITE_ACCEL 0.1
#define SPRITE_JUMPSPEED -4
#define SPRITE_GRAVITY 0.09
#define SPRITE_FALLSILENTTHRESHOLD 1.0

// Scores
#define PIXEL_SCORE 20
#define EXTRAPOINTS_VALUE 150

// Max. Players
#define MAX_PLAYERS 1

//main.cpp
extern SDL_Surface *gScreen;

// Last iteration's tick value
extern Uint32 gLastTick;

// Show info inlays?
//#define SHOW_INLAY

// Maximum length of RESPATH+filenames
#define MAX_FNAME_LENGTH 500

// Max. legth of all-purpose strings
#define MAX_STRING_LENGTH 1000

// Number of monster bitmaps
#define MAX_MONSTER_TYPES 5

// Speed dying monsters vanish
#define MONSTER_DIESPEED 5

// Sticky-pixels range for elevators (when standing on top)
#define ELEVATOR_STICKYRANGE 7

// Move-types for player and monsters
typedef enum _MOVE_TYPE {
	MOVE_LEFT,
	MOVE_RIGHT,
	JUMP_LEFT,
	JUMP_RIGHT,
	NO_MOVE
} MOVE_TYPE;

// Input timeout for cheatcodes - in miliseconds
#define CHEATTIMEOUT 10000
extern char cheatCode[MAX_STRING_LENGTH];
extern bool enteringCheat;

#ifdef ENABLE_FULLSCREEN
extern bool isFullscreen;
#endif

extern bool enableColor3D;

// Smooth panning
#define ALLOW_SMOOTHPANNING
#define SMOOTHPANNING_FACTOR 24.0

// Foreground objects
//   Maximum number of objects
#define MAX_FGOBJECTS 1000
//   Maximum number of GRAPHICS for the objects
#define MAX_FGOBJECTGFX 2000
#define PSEUDO_FGOBJECTGFXNUM 99000000

// Sound effects (FX)
//  Maximum number of effects
#define MAX_FX_SAMPLES 100

// Audio buffer size
#ifndef AUDIOBUFFERSIZE
#define AUDIOBUFFERSIZE 1024
#endif // AUDIOBUFFERSIZE

// Maximum number of triggers
#define MAX_TRIGGERS 1000

// BLP (BlinkenLights) Streaming
extern char blphost[255] ;
extern short unsigned blpport ;
extern char mcufhost[255] ;
extern short unsigned mcufport ;
// For using BLP-Viewer in local host
#define BLPRANDOM_SOURCEPORT
#define MCUFRANDOM_SOURCEPORT

// Modern g++ wants some - in our case - completly useless constructors
// with are impossible to make and - as said - useless
// define this if you want to shut up this stupid the warnings
//#define SATISFY_CPP_WITH_USELESS_CONSTRUCTORS

// Include OGG/Theora support
//#define HASOGGSUPPORT

#endif // GLOBALS_H
