// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#include "globals.h"
#include "drawprimitives.h"
#include "errorhandler.h"
#include <math.h>
#ifndef M_PI
#define M_PI	3.141592654
#endif
#include <SDL_endian.h> /* für einen 24-Bit-Modus unabhängig von der Bytereihenfolge */


void drawcircle(const Sint32 x, const Sint32 y, const Sint32 radius, const Uint32 color)
{
	float i;
	Sint32 pixelx, pixely ;
	Uint8 r, g, b ;
	SDL_GetRGB(color, gScreen->format, &r, &g, &b);
	for (i=0; i<2*M_PI; i+=0.01) {
		pixelx = x + (Sint32)(radius*cos(i));
		pixely = y + (Sint32)(radius*sin(i));
		if (pixelx >=0 && pixelx < SCR_WIDTH && pixely >=0 && pixely < SCR_HEIGHT)
			DrawPixel(gScreen, pixelx, pixely, r, g, b );
  }
}


// Draw a rectangle - this is just a convinience wrapper around SDL_FillRect
void drawrect(const Sint32 x, const Sint32 y, const Sint32 width, const Sint32 height, const Uint32 color)
{
	SDL_Rect rectLocation = { x, y, width, height };
	SDL_FillRect(gScreen, &rectLocation, color);
}

SDL_Surface * BS_IMG_Load_DisplayFormat(const char * filename, bool die_on_error)
{
        SDL_Surface *temp = IMG_Load(filename);
        if(!temp) {
		if(die_on_error == true) {
                	DIE(ERROR_IMAGE_READ, filename);
		} else {
			return NULL ;
		}
        }
	SDL_Surface * convertedsurface = SDL_DisplayFormat(temp);
	SDL_FreeSurface(temp);
	return convertedsurface ;
}


/* DrawPixel example from http://www.libsdl.de/docs/sdl-intro/sdl-intro.htm */
void DrawPixel(SDL_Surface *screen, int x, int y,Uint8 R, Uint8 G,Uint8 B)
{
    Uint32 color = SDL_MapRGB(screen->format, R, G, B);

    if ( SDL_MUSTLOCK(screen) )
    {
        if ( SDL_LockSurface(screen) < 0 ) {
            return;
        }
    }

    switch (screen->format->BytesPerPixel) {
        case 1: { /* vermutlich 8 Bit */
            Uint8 *bufp;

            bufp = (Uint8 *)screen->pixels + y*screen->pitch + x;
            *bufp = color;
        }
        break;

        case 2: { /* vermutlich 15 Bit oder 16 Bit */
            Uint16 *bufp;

            bufp = (Uint16 *)screen->pixels + y*screen->pitch/2 + x;
            *bufp = color;
        }
        break;

        case 3: { /* langsamer 24-Bit-Modus, selten verwendet */
            Uint8 *bufp;

            bufp = (Uint8 *)screen->pixels + y*screen->pitch + x * 3;
            if(SDL_BYTEORDER == SDL_LIL_ENDIAN) {
                bufp[0] = color;
                bufp[1] = color >> 8;
                bufp[2] = color >> 16;
            } else {
                bufp[2] = color;
                bufp[1] = color >> 8;
                bufp[0] = color >> 16;
            }
        }
        break;

        case 4: { /* vermutlich 32 Bit */
            Uint32 *bufp;

            bufp = (Uint32 *)screen->pixels + y*screen->pitch/4 + x;
            *bufp = color;
        }
        break;
    }
    if (SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
}

