// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#ifndef BSSCREEN_H
#define BSSCREEN_H

#include "globals.h"
SDL_Surface* BS_SetVideoMode(Uint32 width, Uint32 height, Uint32 depth, Uint32 flags);
int BS_Flip(SDL_Surface* myscreen);
void BS_OLPCScreenZoom(SDL_Surface *src, SDL_Surface *dst);
void BS_SetRealResolution(Uint32 width, Uint32 height, bool smoothieZoom);

typedef enum _COLOR3D {
	COLOR3D_NONE,
	COLOR3D_LEFT,
	COLOR3D_RIGHT
} COLOR3D;

void BS_Set3DMode(COLOR3D mode);
void BS_ColorSurfacesToScreen();
void BS_ColorToGreyscale();

#endif // BSSCREEN_H
