// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See LICENSE for licensing information

// This file defines the globals as external variables
// The globals are declared and initialized in their respective program parts
//


#ifndef GLOBALS_H
#define GLOBALS_H


/*
 * ATTENTION: The following #define is used for the version-numbers of RPMs, tar.gz's, ...
 * so it should only contain Numbers and dots.
 * I grep for that #define in the Makefile, so there should no other #define
 * which starts with "VERSION" (eg. "#define VERSION2" or similar) and there
 * should be exactly ONE Space between "define", "VERSION" and the version-number.
 */
#define VERSION 0.5.2
#define LONGVERSION "Version: 0.5.2"
#define WEBVERSION "V0.5.2"

// Special CD Edition?
#define CDEDITION

// Running on Blink-O-Mat
//#define BLINKOMATEDITION

// RELEASEMODE = less debug info, show intro
#define CAVAC_RELEASEMODE

// FULLSCREEN?
#define ENABLE_FULLSCREEN
#define START_WITH_FULLSCREEN

// SHOW FPS?
#define SHOWFRAMERATE

// Allow cheats?
#define ALLOW_CHEATCODES
#define CHEATCODECHARS "abcdefghijklmnopqrstuvwxyz0123456789 "

#define NAMECODECHARS "abcdefghijklmnopqrstuvwxyz0123456789 "

// Display player coordinates?
#define DISPLAY_PLAYERCOORDS

// Allow ActionCapture
//#define ALLOW_ACTIONCAPTURE
#ifdef ALLOW_ACTIONCAPTURE
#define ACTIONCAPTURE_MAX 200
#define ACTIONCAPTURE_DELAY 100
#define ACTIONCAPTURE_HEIGHT 192
#define ACTIONCAPTURE_WIDTH 256
#endif

// Allow Position-capturing for Attrack-mode
//#define ALLOW_POSITIONCAPTURE

// Allow Bosskey (ESC is instant quit)
#define ALLOW_BOSSKEY

// New colission detection?
//#define USE_NEWCOLDETECT

// Disable sound?
//#define DISABLE_SOUND

// Disable networking?
//#define DISABLE_NETWORK


// Include SDL and helpers
#include <stdlib.h>
#include <math.h>
#include "SDL.h"
//#include <SDL_image.h>

// PATH TO RESOURCES
// Screen
#define SCR_WIDTH 480
#define SCR_HEIGHT 272
#else // OGGPLAYER

// Physics iterations per second
#define PHYSICSFPS 100

// BLP (BlinkenLights) Streaming
#define ALLOW_BLPSTREAM
#define BLPSTREAM_TARGETHOST "192.168.0.10"
#define BLPSTREAM_TARGETPORT 2323

#define MCUFSTREAM_TARGETHOST "192.168.0.10"
#define MCUFSTREAM_TARGETPORT 2323


extern SDL_Surface *gScreen;

#endif // GLOBALS_H
