// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#include "globals.h"
#include "drawprimitives.h"
#include <math.h>

extern SDL_Surface *gScreen;
void drawcircle(Sint32 x, Sint32 y, Sint32 r, Uint32 c)
{
	Uint32 pitch = gScreen->pitch / 4;
	
	Sint32 i, j;
	for (i = 0; i < 2 * r; i++)
	{
		// vertical clipping: (top and bottom)
		if ((y - r + i) >= 0 && (y - r + i) < SCR_HEIGHT)
		{
			Sint32 len = (int)sqrt((float)(r * r - (r - i) * (r - i))) * 2;
			Sint32 xofs = x - len / 2;
			
			// left border
			if (xofs < 0)
			{
				len += xofs;
				xofs = 0;
			}
			
			// right border
			if (xofs + len >= SCR_WIDTH)
			{
				len -= (xofs + len) - SCR_WIDTH;
			}
			Sint32 ofs = (y - r + i) * pitch + xofs;
			
			// note that len may be 0 at this point, 
			// and no pixels get drawn!
			for (j = 0; j < len; j++)
				((Uint32*)gScreen->pixels)[ofs + j] = c;
		}
	}
}


void drawrect(Sint32 x, Sint32 y, Sint32 width, Sint32 height, Sint32 c)
{
	Sint32 i, j;
	Sint32 pitch = gScreen->pitch / 4;
	
	for (i = 0; i < height; i++)
	{
		// vertical clipping: (top and bottom)
		if ((y + i) >= 0 && (y + i) < SCR_HEIGHT)
		{
			Sint32 len = width;
			Sint32 xofs = x;
			
			// left border
			if (xofs < 0)
			{
				len += xofs;
				xofs = 0;
			}
			
			// right border
			if (xofs + len >= SCR_WIDTH)
			{
				len -= (xofs + len) - SCR_WIDTH;
			}
			Sint32 ofs = (i + y) * pitch + xofs;
			
			// note that len may be 0 at this point, 
			// and no pixels get drawn!
			for (j = 0; j < len; j++)
				((Uint32*)gScreen->pixels)[ofs + j] = c;
		}
	}
}
