// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
// BXXViewer by Dirk Pannenbecker
// 
// See LICENSE for licensing information
//


#include <stdlib.h>
#include <string.h>
#include "globals.h"
#include "bxxstream.h"

extern "C" int SDL_main(int argc, char *argv[]);

// Screen surface
SDL_Surface *gScreen = 0;

// Last iteration's tick value
#include "SDL_types.h"
Uint32 gLastTick;
SDL_Joystick *gJoystick = NULL;
bool soundOK;
char * playlist = NULL ;

// Entry point
int main(int argc, char *argv[])
{
	Uint32 bxxreturn = true;
	// Initialize SDL's subsystems
	Uint32 SDLinitflags = SDL_INIT_VIDEO | SDL_INIT_JOYSTICK;
#ifndef CAVAC_RELEASEMODE
		SDLinitflags = SDLinitflags |SDL_INIT_NOPARACHUTE;
#endif // CAVAC_RELEASEMODE

	if ( SDL_Init(SDLinitflags) < 0 ) {
		fprintf(stderr, "Unable to init SDL: %s\n", SDL_GetError());
		exit(1);
	}
	if (SDL_NumJoysticks() > 0)
	{
		gJoystick = SDL_JoystickOpen(0);
		//printf("Defined Joystick is: %s\n",USB_JOY_NAME);
		printf("Joystick found....\n");
		printf("JoystickName: %s\n",SDL_JoystickName(0));
		printf("NumAxes: %d\n",SDL_JoystickNumAxes(gJoystick));
		printf("NumBalls: %d\n",SDL_JoystickNumBalls(gJoystick));
		printf("NumHats: %d\n",SDL_JoystickNumHats(gJoystick));
		printf("NumNumButtons: %d\n",SDL_JoystickNumButtons(gJoystick));
		if (SDL_JoystickNumAxes(gJoystick) < 2)
		{
			// Not enough axes for our use; don't use the joystick.
			printf("Not enough axes for our use; don't use the joystick.\n");
			SDL_JoystickClose(gJoystick);
			gJoystick = NULL;
		}
	}
	atexit(SDL_Quit);
	
	// Attempt to create a SCR_WIDTHxSCR_HEIGHT window with 32bit pixels.
	
	gScreen = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_DEPTH, SDL_SWSURFACE);

	SDL_WM_SetCaption("BXXViewer", "BXX Viewer"); // Window title

	if ( gScreen == NULL ) 
	{
		fprintf(stderr, "Unable to set %d x %d videomode: %s\n", SCREEN_WIDTH, SCREEN_HEIGHT, SDL_GetError());
		exit(1);
	}

	FILE * pFile;
	char buffer[2048];
	int count = 0, colored = 0;

  //open file
	pFile = fopen( "playlist.txt", "rt" );
	if( pFile == NULL )
		return 0;

	while( ! feof( pFile ) ) {
		if( fscanf( pFile, "%d %d %s", &count, &colored, buffer ) != 0 ) {
			printf("will play %s %d times\n", buffer, count);
			for (Uint32 i = 0; i < (Uint32)count; i++) {
				printf("nr %d...\n", (i+1));
				initBXXMovie(buffer);
				while(1) {
					if ((bxxreturn = playBXXMovie(colored))!=true)
						break;
				}
				deInitBXXMovie();
				if(bxxreturn==2){ // quit
					break;
				}
			}
			if(bxxreturn==2){ // quit
				break;
			}
		}
	}
	return 0;
}

#if WIN32

#include <windows.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <fstream>

void RedirectIOToConsole()
{
	int hConHandle;
	long lStdHandle;
	CONSOLE_SCREEN_BUFFER_INFO coninfo;
	FILE *fp;

	// allocate a console for this app

	AllocConsole();
	// set the screen buffer to be big enough to let us scroll text

	GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE),&coninfo);
	coninfo.dwSize.Y = 40;
	SetConsoleScreenBufferSize(GetStdHandle(STD_OUTPUT_HANDLE),	coninfo.dwSize);

	// redirect unbuffered STDOUT to the console

	lStdHandle = (long)GetStdHandle(STD_OUTPUT_HANDLE);
	hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);

	fp = _fdopen( hConHandle, "w" );

	*stdout = *fp;
	setvbuf( stdout, NULL, _IONBF, 0 );

	// redirect unbuffered STDIN to the console
	lStdHandle = (long)GetStdHandle(STD_INPUT_HANDLE);
	hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);

	fp = _fdopen( hConHandle, "r" );
	*stdin = *fp;
	setvbuf( stdin, NULL, _IONBF, 0 );

	// redirect unbuffered STDERR to the console

	lStdHandle = (long)GetStdHandle(STD_ERROR_HANDLE);
	hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
	fp = _fdopen( hConHandle, "w" );
	*stderr = *fp;
	setvbuf( stderr, NULL, _IONBF, 0 );
}

void RedirectIOToFiles()
{
	FILE *fp;

	// allocate a console for this app


	// redirect unbuffered STDOUT to the console

	fp = fopen( "stdoutstderr_bp.txt", "w" );

	*stdout = *fp;
	setvbuf( stdout, NULL, _IONBF, 0 );

	// redirect unbuffered STDERR to the console
	*stderr = *fp;
	setvbuf( stderr, NULL, _IONBF, 0 );
}

int WINAPI WinMain(  HINSTANCE hInstance,      // handle to current instance
  HINSTANCE hPrevInstance,						// handle to previous instance
  LPSTR lpCmdLine,								// command line
  int nCmdShow									// show state
  )
{

    if(hInstance || hPrevInstance || nCmdShow) {
                 // Supress "unused variables" warning
    }

	int argc = 0;
	int i=0;
	if (lpCmdLine[0]) // at least one paramteter
		argc = 1;
	while (lpCmdLine[i])
	{
		if (lpCmdLine[i] == ' ')
			argc++;
		i++;
	}
	argc++;  // add app name

	char** argv = (char**)malloc(argc*sizeof(char*));
	char appName[500];
	GetModuleFileNameA(0, appName, sizeof(appName));
	char* p;
	
	while((p= strrchr(appName,'\\')))
		*p= '/';
	p= argv[0] = (char*)malloc(strlen(appName)+10);
	strcpy(p,appName);

	i = argc-1;
	char* strptr = strrchr(lpCmdLine, ' ');
	while (strptr)
	{
		p=argv[i] = (char*)malloc(strlen(strptr+1)+10);
		strcpy( p,strptr+1);
		*strptr = '\0';
		i--;
		strptr = strrchr(lpCmdLine, ' ');
	}
	if (lpCmdLine[0])
	{
		p=argv[1] = (char*)malloc(strlen(lpCmdLine)+1);
		strcpy(p,lpCmdLine);
	}
	//RedirectIOToConsole();
	RedirectIOToFiles();

	return main(argc, argv);
}
#endif // WIN32

