
// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#include "globals.h"
#include "errorhandler.h"
#include "fonthandler.h"
#include "SDL_ttf.h"
#include "showtext.h"
#include <string.h>



TTF_Font* FONT_menufont_50;
TTF_Font* FONT_menufont_30;
TTF_Font* FONT_textfont_30;
TTF_Font* FONT_menufont_20;
TTF_Font* FONT_textfont_20;
TTF_Font* FONT_textfont_8;
TTF_Font* FONT_errorfont_12;


#ifdef __OGGPLAYER
SDL_Color MENUCOLOR_ACTIVE   = { 0xff, 0xff, 0xff, 0 };
SDL_Color MENUCOLOR_INACTIVE = { 0xa0, 0xa0, 0xa0, 0 };
#endif // __OGGPLAYER


void initFontHandler() {
	printf("Init TTF\n");
	if(TTF_Init()) {
		fprintf(stderr, "TTF_Init error: %s\n", TTF_GetError());
		DIE(ERROR_FONTLOAD, "TTF_Init");
	}

	FONT_menufont_50 = TTF_OpenFont(RESPATH "Ghostmeat.ttf", 50);
	if(!FONT_menufont_50) {
		fprintf(stderr, "TTF_OpenFont error: %s\n", TTF_GetError());
		DIE(ERROR_FONTLOAD, "Ghostmeat.ttf");
	}

	FONT_menufont_20 = TTF_OpenFont(RESPATH "Ghostmeat.ttf", 20);
	if(!FONT_menufont_20) {
		fprintf(stderr, "TTF_OpenFont error: %s\n", TTF_GetError());
		DIE(ERROR_FONTLOAD, "Ghostmeat.ttf");
	}

	FONT_menufont_30 = TTF_OpenFont(RESPATH "Ghostmeat.ttf", 30);
	if(!FONT_menufont_30) {
		fprintf(stderr, "TTF_OpenFont error: %s\n", TTF_GetError());
		DIE(ERROR_FONTLOAD, "Ghostmeat.ttf");
	}


	FONT_textfont_20 = TTF_OpenFont(RESPATH "Georgia.ttf", 20);
	if(!FONT_textfont_20) {
		fprintf(stderr, "TTF_OpenFont error: %s\n", TTF_GetError());
		DIE(ERROR_FONTLOAD, "Georgia.ttf");
	}
	FONT_textfont_30 = TTF_OpenFont(RESPATH "Georgia.ttf", 30);
	if(!FONT_textfont_30) {
		fprintf(stderr, "TTF_OpenFont error: %s\n", TTF_GetError());
		DIE(ERROR_FONTLOAD, "Georgia.ttf");
	}

	FONT_textfont_8 = TTF_OpenFont(RESPATH "Georgia.ttf", 8);
	if(!FONT_textfont_8) {
		fprintf(stderr, "TTF_OpenFont error: %s\n", TTF_GetError());
		DIE(ERROR_FONTLOAD, "Georgia.ttf");
	}

	FONT_errorfont_12 = TTF_OpenFont(RESPATH "Georgia.ttf", 12);
	if(!FONT_textfont_20) {
		fprintf(stderr, "TTF_OpenFont error: %s\n", TTF_GetError());
		DIE(ERROR_FONTLOAD, "Georgia.ttf");
	}
}

void deInitFontHandler() {
	TTF_Quit();
}

void renderFontHandlerText(Sint32 x, Sint32 y, const char* text, SDL_Color fontcolor, bool hcentered, bool vcentered, TTF_Font* renderfont) {

	// strdu does not seem to exist/is different on Win32, so use malloc/strcpy instead
	//char * printstring = strdup(text) ; /* create a writeable copy */
	char *printstring = (char*)malloc(strlen(text)+1);
	if(!printstring) {
	    return; // Can't alloc a few bytes, we are in BIG trouble...
	}
	strcpy(printstring, text);
	char * newline = strchr(printstring, '\n') ;
	if (newline != NULL) { /* '\n' found - multiline string */
		*newline = '\0' ; /* set the \n to zero and call the function with the remaining part (newline+1) */
		renderFontHandlerText(x, y+TTF_FontLineSkip(renderfont), newline+1, fontcolor, hcentered, vcentered, renderfont) ;
	} ;
	if(strlen(printstring)==0) { free(printstring); return ; } ; /* do nothing, if text is emtpy */
	SDL_Surface* textsurface;
	if(!TTF_WasInit()) {
		DIE(ERROR_FONTLOAD, "no TTF_Init");
	}

	textsurface = TTF_RenderText_Blended(renderfont, printstring, fontcolor);
	if(!textsurface) {
		// Don't remove this workaround until at least 2010! There are still many broken freetype/sdl_ttf
		// installations out there
		printf("Broken TTF_RenderText_Blended(), please upgrade libfreetype and SDL_ttf! ('%s')\n", text);
		if(hcentered) {
			x = (SCR_WIDTH - getstringwidth(text)) / 2;
		}
		if(vcentered) {
			y = (SCR_HEIGHT - 8) / 2;
		}
		drawstring(x, y, text, gScreen, false);
		free(printstring);
		return;
	} /* end of the workaround */

	// Center text on screen if needed
	if(hcentered) {
		x = (SCR_WIDTH - textsurface->w) / 2;
	}
	if(vcentered) {
		y = (SCR_HEIGHT - textsurface->h) / 2;
	}

	SDL_Rect textLocation = { x, y, 0, 0 };

	// BlitSurface neeeds an UNLOCKED screen!!
	SDL_BlitSurface(textsurface, NULL, gScreen, &textLocation);
	SDL_FreeSurface(textsurface);
	free(printstring);
}

