// BlinkenSisters - Hunt for the Lost Pixels
//     Bringing back the fun of the 80s
//
// (C) 2005-07 Rene Schickbauer, Wolfgang Dautermann
//
// See License.txt for licensing information
//


#ifndef SOUND_H
#define SOUND_H

typedef struct _TITLES {
       char   name[50];
       char   fname[50];
       char   scrolltext[1000];
       Mix_Music* sdlmusic;
} TITLES;

void initSound();
void soundStartMusic();
void soundStopMusic();
void soundPauseMusic();
void deInitSound();
void soundStepNext();
void soundStepPrev();
void soundLoad(Uint32 idx, char* fname);
void soundMusicFinished();
void soundCaptureOutput(int chan, void* stream, int len, void* udata);
extern Sint32 curSnd;
extern Sint32 maxSnd;
extern bool isPlaying;
extern bool isPaused;

extern TITLES titles[100];
extern char captureSound[8192];

#endif // SOUND_H
