/* BlinkenLib
 * version 0.5.2 date 2006-05-10
 * Copyright 2004-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a blinkenarea.org project
 */
#include "../../globals.h"
#include <stdlib.h>

#include "Tools.h"

void * malloc1D( Uint32 count1, Uint32 size )
{
  if( count1 < 1 ) count1 = 1;
  if( size < 1 )
    return NULL;

  return malloc( count1 * size );
}

void * * malloc2D( Uint32 count1, Uint32 count2, Uint32 size )
{
  Uint32 sz, i;
  char * p;
  void * * ptr;

  if( count1 < 1 ) count1 = 1;
  if( count2 < 1 ) count2 = 1;
  if( size < 1 )
    return NULL;

  sz = count1 * sizeof( void * ) + count1 * count2 * size;
  p = (char *)malloc( sz );
  if( p == NULL )
    return NULL;

  ptr = (void * *)p;
  p += count1 * sizeof( void * );
  for( i = 0; i < count1; i++ )
  {
    ptr[i] = (void *)p;
    p += count2 * size;
  }
  return ptr;
}
