/* BlinkenLib
 * version 0.5.2 date 2006-05-10
 * Copyright 2004-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a blinkenarea.org project
 */
#ifndef INC_BlinkenMovie
#define INC_BlinkenMovie

#include "BlinkenFrame.h"

#ifndef DISABLE_NETWORK
#include "../../blpstream.h"
#endif // DISABLE_NETWORK

typedef struct sBlinkenMovie stBlinkenMovie;

stBlinkenMovie * BlinkenMovieNew( Uint32 height, Uint32 width, Uint32 channels, Uint32 maxval );

stBlinkenMovie * BlinkenMovieClone( stBlinkenMovie * pSrcMovie );

void BlinkenMovieFree( stBlinkenMovie * pMovie );

Uint32 BlinkenMovieGetHeight( stBlinkenMovie * pMovie );
Uint32 BlinkenMovieGetWidth( stBlinkenMovie * pMovie );
Uint32 BlinkenMovieGetChannels( stBlinkenMovie * pMovie );
Uint32 BlinkenMovieGetMaxval( stBlinkenMovie * pMovie );
Uint32 BlinkenMovieGetDuration( stBlinkenMovie * pMovie );

Uint32 BlinkenMovieGetInfoCnt( stBlinkenMovie * pMovie );
char * BlinkenMovieGetInfoType( stBlinkenMovie * pMovie, Uint32 infoNo );
char * BlinkenMovieGetInfoData( stBlinkenMovie * pMovie, Uint32 infoNo );
void BlinkenMovieSetInfo( stBlinkenMovie * pMovie, Uint32 infoNo, const char * pInfoType, char * pInfoData );
void BlinkenMovieInsertInfo( stBlinkenMovie * pMovie, Uint32 infoNo, const char * pInfoType, char * pInfoData );
void BlinkenMovieAppendInfo( stBlinkenMovie * pMovie, const char * pInfoType, char * pInfoData );
void BlinkenMovieDeleteInfo( stBlinkenMovie * pMovie, Uint32 infoNo );
void BlinkenMovieDeleteInfos( stBlinkenMovie * pMovie );

Uint32 BlinkenMovieGetFrameCnt( stBlinkenMovie * pMovie );
stBlinkenFrame * BlinkenMovieGetFrame( stBlinkenMovie * pMovie, Uint32 frameNo );
void BlinkenMovieSetFrame( stBlinkenMovie * pMovie, Uint32 frameNo, stBlinkenFrame * pFrame );
Sint32 BlinkenMovieInsertFrame( stBlinkenMovie * pMovie, Uint32 frameNo, stBlinkenFrame * pFrame );
Sint32 BlinkenMovieAppendFrame( stBlinkenMovie * pMovie, stBlinkenFrame * pFrame );
void BlinkenMovieDeleteFrame( stBlinkenMovie * pMovie, Uint32 frameNo );
void BlinkenMovieDeleteFrames( stBlinkenMovie * pMovie );

void BlinkenMovieResize( stBlinkenMovie * pMovie, Uint32 height, Uint32 width, Uint32 channels, Uint32 maxval );
void BlinkenMovieScale( stBlinkenMovie * pMovie, Uint32 height, Uint32 width );

char * BlinkenMovieToString( stBlinkenMovie * pMovie );

stBlinkenMovie * BlinkenMovieLoadBlm( char * pFilename );
stBlinkenMovie * BlinkenMovieLoadBmm( char * pFilename );
stBlinkenMovie * BlinkenMovieLoadBml( char * pFilename );
stBlinkenMovie * BlinkenMovieLoadBbm( char * pFilename );
stBlinkenMovie * BlinkenMovieLoad( char * pFilename );

Sint32 BlinkenMovieSaveBlm( stBlinkenMovie * pMovie, char * pFilename );
Sint32 BlinkenMovieSaveBmm( stBlinkenMovie * pMovie, char * pFilename );
Sint32 BlinkenMovieSaveBml( stBlinkenMovie * pMovie, char * pFilename );
Sint32 BlinkenMovieSaveBbm( stBlinkenMovie * pMovie, char * pFilename );
Sint32 BlinkenMovieSave( stBlinkenMovie * pMovie, char * pFilename );

#ifndef DISABLE_NETWORK
//void BlinkenMovieSend( stBlinkenMovie * pMovie, SOCKET udpSocket, etBlinkenProto proto );
//udp socket must be "connected"
void BlinkenMovieSend( stBlinkenMovie * pMovie, UDPsocket locBLPsd, UDPpacket *locBLPp,etBlinkenProto proto );

//stBlinkenMovie * BlinkenMovieReceive( UDPsocket BLPsd, UDPpacket *BLPp, Uint32 timeout, etBlinkenProto * proto );
//udp socket must be "bound" and should be "connected"
//after timeout ms of no reception, the movie is considered to be complete
//returns protocol in *pProto if pProto not NULL
#endif // DISABLE_NETWORK

#endif //#ifndef INC_BlinkenMovie
