/* BlinkenLib
 * version 0.5.2 date 2006-05-10
 * Copyright 2004-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a blinkenarea.org project
 */
#ifndef INC_BlinkenFrame
#define INC_BlinkenFrame

/* Swap bytes in 16 bit value.  */
#define BSWAP_CONSTANT_16(X) \
     ((((X) >> 8) & 0xff) | (((X) & 0xff) << 8))

#define BSWAP_CONSTANT_32(X) \
     ((((X) & 0xff000000) >> 24) | (((X) & 0x00ff0000) >>  8) |		      \
      (((X) & 0x0000ff00) <<  8) | (((X) & 0x000000ff) << 24))

#ifndef ntohl
#define ntohl(x) bswap_32 (x)
#endif

#ifndef ntohs
#define ntohs(x) bswap_16 (x)
#endif

#ifndef htonl
#define htonl(x) bswap_32 (x)
#endif

#ifndef htons
#define htons(x) bswap_16 (x)
#endif

Uint16 bswap_16 (Uint16 bsx);
Uint32 bswap_32 (Uint32 bsx);

typedef struct sBlinkenFrame stBlinkenFrame;

typedef enum eBlinkenProto { BlinkenProtoNone, BlinkenProtoBlp, BlinkenProtoEblp, BlinkenProtoMcuf } etBlinkenProto;

stBlinkenFrame * BlinkenFrameNew( Uint32 height, Uint32 width, Uint32 channels, Uint32 maxval, Uint32 duration );

stBlinkenFrame * BlinkenFrameClone( stBlinkenFrame * pSrcFrame );

void BlinkenFrameFree( stBlinkenFrame * pFrame );

void BlinkenFrameClear( stBlinkenFrame * pFrame );

Uint32 BlinkenFrameGetHeight( stBlinkenFrame * pFrame );
Uint32 BlinkenFrameGetWidth( stBlinkenFrame * pFrame );
Uint32 BlinkenFrameGetChannels( stBlinkenFrame * pFrame );
Uint32 BlinkenFrameGetMaxval( stBlinkenFrame * pFrame );

Uint32 BlinkenFrameGetDuration( stBlinkenFrame * pFrame );
void BlinkenFrameSetDuration( stBlinkenFrame * pFrame, Uint32 duration );

unsigned char BlinkenFrameGetPixel( stBlinkenFrame * pFrame, Uint32 y, Uint32 x, Uint32 c );
void BlinkenFrameSetPixel( stBlinkenFrame * pFrame, Uint32 y, Uint32 x, Uint32 c, unsigned char val );

unsigned long BlinkenFrameGetColor( stBlinkenFrame * pFrame, Uint32 y, Uint32 x );
void BlinkenFrameSetColor( stBlinkenFrame * pFrame, Uint32 y, Uint32 x, unsigned long color );

void BlinkenFrameResize( stBlinkenFrame * pFrame, Uint32 height, Uint32 width, Uint32 channels, Uint32 maxval );
void BlinkenFrameScale( stBlinkenFrame * pFrame, Uint32 height, Uint32 width );

char * BlinkenFrameToString( stBlinkenFrame * pFrame );

Sint32 BlinkenFrameToNetwork( stBlinkenFrame * pFrame, etBlinkenProto proto, char * pData, Uint32 maxLength );
//returns length or -1 on error

stBlinkenFrame * BlinkenFrameFromNetwork( char * pData, Uint32 length, etBlinkenProto * pProto );
//returns protocol in *pProto if pProto not NULL

#endif //#ifndef INC_BlinkenFrame
