// Bastard File System
// (C) 2007 Rene Schickbauer
//
// The Bastard File System (BFS) is a small virtual FS for Applications
// that would normally use Tarballs and/or Zipfiles but have to dynamically
// change its contents
//
// WARNING: This is still ALPHA QUALITY CODE! Use with care!
//
//
#include "bfs_header.h"
#include "bfs.h"
#include "bfs_rawio.h"
#include "string.h"

    
bool readHeaderBlock(sBFS* handle, int blocknum, BLOCK_HEADER* data) {
    BLOCK_RAW raw;
    int blocknum_real = blocknum + 1; // Calculate offset from start of file
    
    if(!readRawBlock(handle, blocknum_real, &raw)) {
        return false;
    }
    memcpy(data, &raw, 512); // Assume compiler adds no stupid padding
    
    
    return true;
}


bool writeHeaderBlock(sBFS* handle, int blocknum, BLOCK_HEADER* data) {
    BLOCK_RAW raw;
    int blocknum_real = blocknum + 1; // Calculate offset from start of file
    
    memset(&raw, 0, sizeof(raw));
    
    // copy data to RAW block
    memcpy(&raw, data, 512); // Assume compiler adds no stupid padding
    
    return writeRawBlock(handle, blocknum_real, &raw);
    
}

bool writeHeaders(sBFS* handle) {
    // Write file blocks
    BLOCK_HEADER header;
 	int i, j;
    for(i = 0; i < handle->numHeadBlocks; i++) {
        for(j = 0; j < 512; j++) {
            header.blockType[j] = handle->blocktype[j + (i * 512)];
        }
        if(!writeHeaderBlock(handle, i, &header)) {
            return false;
        }
    }
    return true;
}
