// Bastard File System
// (C) 2007 Rene Schickbauer
//
// The Bastard File System (BFS) is a small virtual FS for Applications
// that would normally use Tarballs and/or Zipfiles but have to dynamically
// change its contents
//
// WARNING: This is still ALPHA QUALITY CODE! Use with care!
//
//
#ifndef BFS_DATA
#define BFS_DATA

// This is just a wrapper around all datablock functions to calculate the correct
// block offset, as well as handling read/write for the varios data-block types

#include "bfs.h"

// ** WRAPPER
bool readDataBlock(sBFS* handle, int blocknum, BLOCK_RAW* data);
bool writeDataBlock(sBFS* handle, int blocknum, BLOCK_RAW* data);


// ** Type handler **
bool readDataBlock_Free(sBFS* handle, int blocknum, BLOCK_FREE* data);
bool writeDataBlock_Free(sBFS* handle, int blocknum, BLOCK_FREE* data);

bool readDataBlock_File(sBFS* handle, int blocknum, BLOCK_FILE* data);
bool writeDataBlock_File(sBFS* handle, int blocknum, BLOCK_FILE* data);

bool readDataBlock_Dir(sBFS* handle, int blocknum, BLOCK_DIR* data);
bool writeDataBlock_Dir(sBFS* handle, int blocknum, BLOCK_DIR* data);

#endif // BFS_DATA
