-- write out that we loaded sucessfully (mor or less, anyway)
io.write("Starting script for Level8 in BlinkenLUA / ",_VERSION,"!\n")
bs.callback.engine.init("initLevel");


-- Required function: Initializing the level
function initLevel ()
    -- preload all gfx (on-the-fly loading is NOT recommended)
    GFX_SWITCH_RED = bs.gfx.load("fg_switch_red.bmp");
    GFX_SWITCH_GREEN = bs.gfx.load("fg_switch_green.bmp");
	

    -- create door and switch
	switchon = 0;
    OBJ_SWITCH = bs.obj.new(112*32, 11*32, GFX_SWITCH_RED, "visible");
	OBJ_SWITCH.callback.playeraction("handleDoorAction");
	
	
    -- load extra sound
    SND_DOOR_OPEN = bs.snd.load("fx_open_door.ogg");
    SND_DOOR_CLOSE = bs.snd.load("fx_open_door.ogg");
    

    -- Antigrav 
    GFX_ANTIGRAV = bs.anim.load("level8_antigrav%.jpg", 1, 4, 5, bs.anim.type.pingpong);
    OBJ_ANTIGRAV = bs.obj.new(6*32, 12*32, GFX_ANTIGRAV, "!visible");
    
	
	bs.callback.engine.physics("scriptPhysics");
end

-- Required function: Physics-loop for scripting part
function scriptPhysics ()
    if switchon == 1 then
		x = bs.player.x();
		y = bs.player.y();
		if x > 192 and x < 3040 and y > 384 and y < 640 then
			bs.level.freemovement(bs.yes);
		else
			bs.level.freemovement(bs.no);
		end
    end

end

-- Required function: Callback on "Action"-Button on FG-Objects
function handleDoorAction (obj_id)
    -- Open door if not open
	switchon = 1 - switchon;
	if switchon == 1 then
		OBJ_SWITCH.gfx(GFX_SWITCH_GREEN);
	    SND_DOOR_OPEN.play();
		OBJ_ANTIGRAV.visible(bs.yes);
	else
		OBJ_SWITCH.gfx(GFX_SWITCH_RED);
	    SND_DOOR_CLOSE.play();
		OBJ_ANTIGRAV.visible(bs.no);
	end
end
