-- write out that we loaded sucessfully (mor or less, anyway)
io.write("Starting script for Level20 in BlinkenLUA / ",_VERSION,"!\n");

bs.callback.engine.init("initLevel");

-- Required function: Initializing the level
function initLevel ()
    -- disable parallax-scrolling
	bs.level.lockedbg(bs.yes);
    -- create WormHole-Gfx
   	bs.include("_wormhole.inc.bsl");
	Wormhole:new(13*32, 11*32, 13*32, 6*32, "32");
	
	-- User objects
	gfx_a = bs.gfx.load("fg_barock_tile_top.png");
	gfx_b = bs.gfx.load("fg_barock_tile_top2.png");
	gfx_c = bs.gfx.load("fg_barock_tile.png");
	
	gfx_u = bs.gfx.load("underconstruction64.png");
	gfx_v = bs.gfx.load("underconstruction230.png");

	for k, v in pairs (bs.level.tiles.data) do
		if v.type == bs.level.tiles.types["char_a"] then
			bs.obj.new(v.x, v.y, gfx_a, "visible,blocking");
		elseif v.type == bs.level.tiles.types["char_b"] then
			bs.obj.new(v.x, v.y, gfx_b, "visible,blocking");
		elseif v.type == bs.level.tiles.types["char_c"] then
			bs.obj.new(v.x, v.y, gfx_c, "visible,blocking");
		elseif v.type == bs.level.tiles.types["char_u"] then
			foo = bs.obj.new(v.x, v.y, gfx_u, "visible");
			foo.callback.playeraction("UnderConstructionCallback");
		elseif v.type == bs.level.tiles.types["char_v"] then
			sign = bs.obj.new(v.x, v.y, gfx_v, "ontop");
		end
	end
	
	sign_timer = 0;
	sign_player_pos_x = 0;
	sign_player_pos_y = 0;
	
	bs.callback.engine.physics("scriptPhysics");
end

function scriptPhysics ()
	if bs.player.y() > 540 then
		bs.player.kill();
	end
	if sign_timer > 0 then
		sign_timer = sign_timer - 1;
		bs.player.x(sign_player_pos_x);
		bs.player.y(sign_player_pos_y);
		if sign_timer == 0 then
			sign.visible(bs.no);
		end
	end
end

function UnderConstructionCallback ()
	sign.visible(bs.yes);
	sign_timer = 230;
	sign_player_pos_x = bs.player.x();
	sign_player_pos_y = bs.player.y();
end
