-- write out that we loaded sucessfully (mor or less, anyway)
io.write("Starting script for Level: Desert 5 (18) in BlinkenLUA / ",_VERSION,"!\n")

-- declare some global variables

--sound
SND_DOOR_OPEN = -1;
SND_DOOR_CLOSE = -1;
SND_BEAM = -1;

-- Fire-Tiles
-- --Config-- How many Fire-Tiles are there overall?
COUNT_FIRETILES = 1;
-- -- End of Config --
-- --Config-- Where should they be (x,y)
CFG_FIRETILES_VALUES_Y = { 80 };
CFG_FIRETILES_VALUES_X = { 227 };
for i=69,104 do
    COUNT_FIRETILES=COUNT_FIRETILES+1;
    CFG_FIRETILES_VALUES_Y[COUNT_FIRETILES] = 52;
    CFG_FIRETILES_VALUES_X[COUNT_FIRETILES] = i;
end
for i=54,60 do
    COUNT_FIRETILES=COUNT_FIRETILES+1;
    CFG_FIRETILES_VALUES_Y[COUNT_FIRETILES] = 52;
    CFG_FIRETILES_VALUES_X[COUNT_FIRETILES] = i;
end
for i=257,266 do
    COUNT_FIRETILES=COUNT_FIRETILES+1;
    CFG_FIRETILES_VALUES_Y[COUNT_FIRETILES] = 84;
    CFG_FIRETILES_VALUES_X[COUNT_FIRETILES] = i;
end
for i=243,247 do
    COUNT_FIRETILES=COUNT_FIRETILES+1;
    CFG_FIRETILES_VALUES_Y[COUNT_FIRETILES] = 106;
    CFG_FIRETILES_VALUES_X[COUNT_FIRETILES] = i;
end
for i=98,121 do
    COUNT_FIRETILES=COUNT_FIRETILES+1;
    CFG_FIRETILES_VALUES_Y[COUNT_FIRETILES] = 83;
    CFG_FIRETILES_VALUES_X[COUNT_FIRETILES] = i;
end
for i=106,109 do
    COUNT_FIRETILES=COUNT_FIRETILES+1;
    CFG_FIRETILES_VALUES_Y[COUNT_FIRETILES] = 37;
    CFG_FIRETILES_VALUES_X[COUNT_FIRETILES] = i;
end
-- -- End of Config --


GFX_FIRETILES = {};
for i=1,6 do
    GFX_FIRETILES[i]=-1;
end
OBJ_FIRETILES = {};
STATUS_FIRETILES = {};
for i=1,COUNT_FIRETILES do
    OBJ_FIRETILES[i] = -1;
    STATUS_FIRETILES[i] = math.random(6);
end

-- beaming
-- --Config-- from where to where
COUNT_BEAMS=8;
CFG_BEAM_FROM_X_MIN = { 77, 229, 256, 247, 279, 187, 179, 202 };
CFG_BEAM_FROM_X_MAX = { 77, 229, 256, 250, 279, 189, 179, 203};
CFG_BEAM_FROM_Y_MIN = { 77, 31, 36, 70, 61, 105, 29, 49 };
CFG_BEAM_FROM_Y_MAX = { 77, 31, 36, 71, 61, 106, 29, 50 };
CFG_BEAM_TO_X = { 57, 57, 57, 57, 57, 57, 57, 205};
CFG_BEAM_TO_Y = { 26, 26, 26, 26, 26, 26, 26, 48};
-- -- End of Config --
-- --Config--
COUNT_WORMHOLES=8;
-- -- End of Config --

GFX_WORM_HOLE_SMALL = -1;
GFX_WORM_HOLE_BIG = -1;
OBJ_WORM_HOLE = {};
for i=1,COUNT_WORMHOLES do
    OBJ_WORM_HOLE[i] = -1;
end

-- sign-switches and doors
--      (sry - I'm unable to translate the following line to english... pls do so if u can!)
--   9 Switches, die zusammen ein Bild ergeben wie in klein bei fg_sign_X.png zu sehen ist, angeordnet wie folgt:
--    7 8 9
--    4 5 6
--    1 2 3
--   (just like the num-pad on your keyboard usually)

GFX_SIGN_SWITCH_RED = -1;
GFX_SIGN_SWITCH_GREEN = -1;
SND_SIGN_SWITCH_ON = -1;
SND_SIGN_SWITCH_OFF = -1;

OBJ_SIGN_SWITCH = {};
STATUS_SIGN_SWITCH = {};
--   STATUS_SIGN_SWITCH[ Switch 1..9 ]: 0 = red/off, 1 = green/on(default)

for i=1,9 do
    OBJ_SIGN_SWITCH[i] = -1;
    STATUS_SIGN_SWITCH[i] = 1;
end
-- --Config-- How many "Sign-Doors" are there overall?
COUNT_SIGN_DOORS=15;
-- -- End of Config --

CFG_SIGN_DOORS_SWITCH_VALUE = {};
for d = 1,COUNT_SIGN_DOORS do
    CFG_SIGN_DOORS_SWITCH_VALUE[d] = {};
    for s = 1,9 do
        CFG_SIGN_DOORS_SWITCH_VALUE[d][s]=0;
    end
end

-- --Config-- defines the required "code" needed for each door to be opend
--   CFG_SIGN_DOORS_SWITCH_VALUE[ Door 1..COUNT_SIGN_DOORS ][ Switch 1..9 ] = VALUE;
--    where VALUE is one off: 0=may be red or green(default), 1=must be red, 2=must be green
--   Example: If only the following line exists for door Nr 1, then the only
--    precondition to open door Nr 1 is that Switch Nr 9 (upper right corner) has
--    to be red. All other Switches may be red or green.
--     CFG_SIGN_DOORS_SWITCH_VALUE[1][9] = 1;

-- a
CFG_SIGN_DOORS_SWITCH_VALUE[1][9] = 1;

-- b
CFG_SIGN_DOORS_SWITCH_VALUE[2][6] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[2][5] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[2][8] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[2][9] = 1;

-- c
CFG_SIGN_DOORS_SWITCH_VALUE[3][1] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[3][4] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[3][6] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[3][9] = 2;

-- d
CFG_SIGN_DOORS_SWITCH_VALUE[4][2] = 1;

-- e
CFG_SIGN_DOORS_SWITCH_VALUE[5][4] = 1;

-- f
CFG_SIGN_DOORS_SWITCH_VALUE[6][2] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[6][3] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[6][5] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[6][6] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[6][8] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[6][9] = 1;

-- g
CFG_SIGN_DOORS_SWITCH_VALUE[7][2] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[7][3] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[7][5] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[7][6] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[7][8] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[7][9] = 1;

-- h
CFG_SIGN_DOORS_SWITCH_VALUE[8][1] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[8][2] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[8][3] = 2;

-- i
CFG_SIGN_DOORS_SWITCH_VALUE[9][1] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[9][2] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[9][3] = 2;

-- j
CFG_SIGN_DOORS_SWITCH_VALUE[10][1] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[10][2] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[10][3] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[10][7] = 1;

-- k
CFG_SIGN_DOORS_SWITCH_VALUE[11][2] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[11][7] = 1;

-- l
CFG_SIGN_DOORS_SWITCH_VALUE[12][1] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[12][7] = 2;

-- m
CFG_SIGN_DOORS_SWITCH_VALUE[13][2] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[13][5] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[13][7] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[13][8] = 2;

-- n
CFG_SIGN_DOORS_SWITCH_VALUE[14][7] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[14][8] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[14][9] = 2;

-- o
CFG_SIGN_DOORS_SWITCH_VALUE[15][2] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[15][3] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[15][5] = 2;
CFG_SIGN_DOORS_SWITCH_VALUE[15][7] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[15][8] = 1;
CFG_SIGN_DOORS_SWITCH_VALUE[15][9] = 2;

-- -- End of Config --

GFX_SIGN_DOOR = {};
OBJ_SIGN_DOOR = {};

--   STATUS_SIGN_DOOR[ Door 1..COUNT_SIGN_DOORS ]: 0 = closed(default), 1 = open
STATUS_SIGN_DOOR = {};

for i=1,COUNT_SIGN_DOORS do
    GFX_SIGN_DOOR[i]=-1;
    OBJ_SIGN_DOOR[i]=-1;
    STATUS_SIGN_DOOR[i]=0;
end

-- special background
GFX_SPECIAL_BG = -1;
OBJ_SPECIAL_BG = -1;


-- elevators
Y_KORREKTUR=640;
X_KORREKTUR=32;

-- --Config-- How many Elevators are there overall?
COUNT_ELEVATORS = 9;
-- -- End of Config --
-- --Config-- Where should they be (permanet x-coord, min and max y-coord, start y-coord, how fast, ..
CFG_ELEVATOR_VALUES_X = { 3820, 3700, 3820,  4500, 5900, 210,  367, 1680, 8693 };
CFG_ELEVATOR_VALUES_Y_MIN = { 110, 385, 660,  920, 1520, 1900,  1900, 1120, 1770 };
CFG_ELEVATOR_VALUES_Y_MAX = { 410, 685, 960,  1490, 1865, 2900,  2650, 1650, 2900 };
CFG_ELEVATOR_VALUES_Y_POS = { 400, 395, 950,  1000, 1600, 2000,  2000, 1500, 2000 };
CFG_ELEVATOR_VALUES_DIR = { 1, 1, 1,  1, 1, 1,  1, 1, 2 };
CFG_ELEVATOR_VALUES_BLINK_ON = { 2,1,2, 2,2,2, 1,2,1 };
CFG_ELEVATOR_VALUES_BLINK_OFF = { 1,2,1, 1,1,1, 2,1,2 };
-- -- End of Config --

BLINKEN_TIMER = 0;
GFX_ELEVATOR = {};
GFX_ELEVATOR[1]=-1;
GFX_ELEVATOR[2]=-1;
OBJ_ELEVATOR = {};
for i=1,COUNT_ELEVATORS do
    OBJ_ELEVATOR[i] = -1;
end







-- Required function: Initializing the level
function initLevel ()

    -- create special bg
    --    Load gfx
    GFX_SPECIAL_BG = LoadGFX("fg_desertcave_desertbg.jpg");
   
    for i=0,16 do
        OBJ_SPECIAL_BG = AddObject(GFX_SPECIAL_BG, i*18, 0, 0, 1, 0, 0);
    end
    for i=1,4 do
        OBJ_SPECIAL_BG = AddObject(GFX_SPECIAL_BG, i*18, 1, 0, 1, 0, 0);
    end
    
    -- Create Fire-Tiles
    --    Load gfx
    GFX_FIRETILES[1] = LoadGFX("firetile1.png");
    GFX_FIRETILES[2] = LoadGFX("firetile2.png");
    GFX_FIRETILES[3] = LoadGFX("firetile3.png");
    GFX_FIRETILES[4] = LoadGFX("firetile4.png");
    GFX_FIRETILES[5] = LoadGFX("firetile5.png");
    GFX_FIRETILES[6] = LoadGFX("firetile6.png");
    
    --    Add Objects
    for i=1,COUNT_FIRETILES do
        OBJ_FIRETILES[i] = AddObject(GFX_FIRETILES[1], (CFG_FIRETILES_VALUES_X[i])-1, (CFG_FIRETILES_VALUES_Y[i])-1, 0, 1, 1, 1);
    end
        
    -- create sign-switches
    --    Load gfx
    GFX_SIGN_SWITCH_RED = LoadGFX("fg_sign_switch_red.png");
    GFX_SIGN_SWITCH_GREEN = LoadGFX("fg_sign_switch_green.png");
    
    --    Add Objects
    tmp_y=30;
    for j=0,2 do
        tmp_x=76;
        for i=1,3 do
            OBJ_SIGN_SWITCH[i+(j*3)] = AddObject(GFX_SIGN_SWITCH_GREEN, tmp_x, tmp_y, 0, 1, 0, 0);
            STATUS_SIGN_SWITCH[i+(j*3)] = 1;
            tmp_x=tmp_x+2;
        end
        tmp_y=tmp_y-2;
    end
    
    -- create WormHoles todo
    GFX_WORM_HOLE_SMALL = LoadGFX("fg_wormhole32x32.png");
    GFX_WORM_HOLE_BIG = LoadGFX("fg_wormhole64x64.png");
    OBJ_WORM_HOLE[1] = AddObject(GFX_WORM_HOLE_SMALL, 76, 76, 0, 1, 1, 0);
    OBJ_WORM_HOLE[2] = AddObject(GFX_WORM_HOLE_SMALL, 228, 30, 0, 1, 1, 0);
    OBJ_WORM_HOLE[3] = AddObject(GFX_WORM_HOLE_SMALL, 253, 37, 0, 1, 1, 0);
    OBJ_WORM_HOLE[4] = AddObject(GFX_WORM_HOLE_SMALL, 248, 70, 0, 1, 1, 0);
    OBJ_WORM_HOLE[5] = AddObject(GFX_WORM_HOLE_SMALL, 278, 60, 0, 1, 1, 0);
    OBJ_WORM_HOLE[6] = AddObject(GFX_WORM_HOLE_BIG, 187, 104, 0, 1, 1, 0);
    OBJ_WORM_HOLE[7] = AddObject(GFX_WORM_HOLE_SMALL, 178, 28, 0, 1, 1, 0);
    OBJ_WORM_HOLE[8] = AddObject(GFX_WORM_HOLE_BIG, 202, 48, 0, 1, 1, 0);
    
    -- create sign-doors
    --   Load gfx, Add Objects
    initSignDoor(1, "fg_sign_a.png", 38, 112);
    initSignDoor(2, "fg_sign_b.png", 100, 23);
    initSignDoor(3, "fg_sign_c.png", 74, 34);
    initSignDoor(4, "fg_sign_d.png", 265, 63);
    initSignDoor(5, "fg_sign_e.png", 265, 61);
    initSignDoor(6, "fg_sign_f.png", 249, 72);
    initSignDoor(7, "fg_sign_g.png", 249, 74);
    initSignDoor(8, "fg_sign_h.png", 254, 63);
    initSignDoor(9, "fg_sign_i.png", 256, 63);
    initSignDoor(10, "fg_sign_j.png", 258, 63);
    initSignDoor(11, "fg_sign_k.png", 75, 104);
    initSignDoor(12, "fg_sign_l.png", 272, 58);
    initSignDoor(13, "fg_sign_m.png", 177, 37);
    initSignDoor(14, "fg_sign_n.png", 134, 44);
    initSignDoor(15, "fg_sign_o.png", 122, 54);

    
    -- load extra sound
    SND_DOOR_OPEN = LoadSoundFX("fx_open_door.ogg");
    SND_DOOR_CLOSED = LoadSoundFX("fx_close_door.ogg");
    SND_SIGN_SWITCH_ON = LoadSoundFX("fx_altemark__bd4.wav");
    SND_SIGN_SWITCH_OFF = LoadSoundFX("fx_altemark__bd5.wav");
    SND_BEAM = LoadSoundFX("fx_altemark__gongend.wav");
   
  
    -- Create elevators
    --    Load gfx
    GFX_ELEVATOR[1] = LoadGFX("elevator2.bmp");
    GFX_ELEVATOR[2] = LoadGFX("elevator1.bmp");
    
    --    Add Objects
    for i=1,COUNT_ELEVATORS do
        OBJ_ELEVATOR[i] = AddObject(GFX_ELEVATOR[1], 43, 22, 1, 1, 0, 0);
        SetElevator(OBJ_ELEVATOR[i], 1);
    end
   
end




-- Required function: Physics-loop for scripting part
function scriptPhysics ()
    x = GetPlayerX();
    y = GetPlayerY();

    -- free movement at the text "the labyrinth"
    if x > 390 and x < 2778 and y > 200 and y < 580 then
        SetFreeMovement(1);
    else
        SetFreeMovement(0);
    end    
    
        
    -- handle beaming
    for i=1,COUNT_BEAMS do
        if x+1>(CFG_BEAM_FROM_X_MIN[i]-1)*32 and x-1<(CFG_BEAM_FROM_X_MAX[i])*32 and y+1>(CFG_BEAM_FROM_Y_MIN[i]-1)*32 and y-1<(CFG_BEAM_FROM_Y_MAX[i])*32 then
            PlaySoundFX(SND_BEAM);
            SetPlayerX((CFG_BEAM_TO_X[i]-1)*32);
            SetPlayerY((CFG_BEAM_TO_Y[i]-1)*32);
        end
    end
    
    
    -- Fire-Tiles, Elevator + SwitchDoor display
    BLINKEN_TIMER = BLINKEN_TIMER + 1;
    if math.mod(BLINKEN_TIMER, 10) == 0 then
        for i=1,COUNT_FIRETILES do
            STATUS_FIRETILES[i] = math.mod(STATUS_FIRETILES[i], 6)+1;
            if (math.random(100)>95) then
                STATUS_FIRETILES[i] = math.random(6);
            end
            SetGFX(OBJ_FIRETILES[i], GFX_FIRETILES[STATUS_FIRETILES[i]]);
        end
    end
    if BLINKEN_TIMER == 30 or BLINKEN_TIMER == 105 then
        for i=1,COUNT_SIGN_DOORS do
            SetVisible(OBJ_SIGN_DOOR[i], 1);
        end
    end
    if BLINKEN_TIMER == 55 or BLINKEN_TIMER == 130 then
        for i=1,COUNT_SIGN_DOORS do
            if STATUS_SIGN_DOOR[i]  == 1 then
                SetVisible(OBJ_SIGN_DOOR[i], 0);
            end
        end
    end
    if BLINKEN_TIMER == 50 then
        for i=1,COUNT_ELEVATORS do
            SetGFX(OBJ_ELEVATOR[i], GFX_ELEVATOR[CFG_ELEVATOR_VALUES_BLINK_ON[i]]);
        end
    end
    if BLINKEN_TIMER > 150 then
        for i=1,COUNT_ELEVATORS do
            SetGFX(OBJ_ELEVATOR[i], GFX_ELEVATOR[CFG_ELEVATOR_VALUES_BLINK_OFF[i]]);
        end
        BLINKEN_TIMER = 0;
    end

    
    -- Elevator physics
    for i=1,COUNT_ELEVATORS do    
        CFG_ELEVATOR_VALUES_Y_POS[i] = CFG_ELEVATOR_VALUES_Y_POS[i] + CFG_ELEVATOR_VALUES_DIR[i];
        if CFG_ELEVATOR_VALUES_Y_POS[i] < CFG_ELEVATOR_VALUES_Y_MIN[i]+1 or CFG_ELEVATOR_VALUES_Y_POS[i] > CFG_ELEVATOR_VALUES_Y_MAX[i]-1 then
            CFG_ELEVATOR_VALUES_DIR[i] = CFG_ELEVATOR_VALUES_DIR[i] * -1;
        end
        SetObjPos(OBJ_ELEVATOR[i], CFG_ELEVATOR_VALUES_X[i]+X_KORREKTUR, CFG_ELEVATOR_VALUES_Y_POS[i]+Y_KORREKTUR);
    end
    
end




-- Required function: Callback on "Action"-Button on FG-Objects
function handleAction (obj_id)
    -- Handle sign-switches
    for i=1,9 do
        if obj_id == OBJ_SIGN_SWITCH[i] then
            handleSignDoor(i);
        end
    end

end







-- Script-internal functions

function initSignDoor(obj_nr, file, x, y)
--     Loads gfx and adds Object at given position ans with app. porp's (blocking, visible, onTop, not killin)
--   Parameter:
--    obj_nr is the Number of the door
--    file is a String with the filename of the gfx-file
--    x and y describe the position of the door (counted in BlinkenPixels(32 real Pixels per one BlinkenPixel), not in real Pixels)
--   Return:
--    nothing
    GFX_SIGN_DOOR[obj_nr] = LoadGFX(file);
    OBJ_SIGN_DOOR[obj_nr] = AddObject(GFX_SIGN_DOOR[obj_nr], x, y, 1, 1, 1, 0);
end




function handleSignDoor(i)
--   called by the required callback handleAction when Switch i ( 1..9 ) is "pushed"
--    toggles the status off the switch (0=red/off, 1=green/on(default)
--    sets the app. picture for the switch
--    and calls handleSignDoorRaetsel(), which checks, if doors have to be opend or closes due to the new switch-status
--   Parameter:
--    i is the Number of the switch that just has been pushed ( 1..9 )
--   Return:
--    nothing
    if STATUS_SIGN_SWITCH[i] == 0 then
        PlaySoundFX(SND_SIGN_SWITCH_ON);
        SetGFX(OBJ_SIGN_SWITCH[i], GFX_SIGN_SWITCH_GREEN);
        STATUS_SIGN_SWITCH[i] = 1;
    else
        PlaySoundFX(SND_SIGN_SWITCH_OFF);
        SetGFX(OBJ_SIGN_SWITCH[i], GFX_SIGN_SWITCH_RED);
        STATUS_SIGN_SWITCH[i] = 0;
    end
    handleSignDoorRaetsel();
end




function handleSignDoorRaetsel()
--      called by handleSignDoor(i), this fkt checks, if doors have to be opend or closes
--       reds status of all 9 switches and all Doors an decides, based on the information
--       in the config-array CFG_SIGN_DOORS_SWITCH_VALUE, if there is a door that have
--       to be opend or closed now.
    play_sound = 3;
    
    --   for each door check if it has to be opend or closed
    for d = 1,COUNT_SIGN_DOORS do
        --   first default to "yes, the door has to be open"
        boolean_activate_door = 1;
        for s = 1,9 do
                if CFG_SIGN_DOORS_SWITCH_VALUE[d][s] > 0 then
                    if STATUS_SIGN_SWITCH[s] == CFG_SIGN_DOORS_SWITCH_VALUE[d][s] -1 then
                    else    
                        --   if at least one switch is in the wrong status for the door-code, the door must not be open!
                        boolean_activate_door = 0;
                    end
                end
        end
        if boolean_activate_door > 0 then
            if STATUS_SIGN_DOOR[d] == 0 then
                --   if the door should be open, but isn't, then open it now
                play_sound = minimum(setSwitchDoorOpenOrClosed(d, 1), play_sound);
            end
        else
            if STATUS_SIGN_DOOR[d] == 1 then
                --   if the door should be closed, but isn't, then close it now
                play_sound = minimum(setSwitchDoorOpenOrClosed(d, 0), play_sound);
            end
        end
    end

--     play_sound=3: play no sound here at end of fkt,
--      1: play sound "door open" here at end of fkt,
--      2: play sound "door closed" here at end of fkt    
    if play_sound == 1 then
        PlaySoundFX(SND_DOOR_OPEN);
    end
    if play_sound == 2 then
        PlaySoundFX(SND_DOOR_CLOSED);
    end
end




function minimum(a, b)
--   returns the smaller number
--   Parameter:
--    a and b are numbers
--   Returns: a if a<b, else b
    if a < b then
        return a;
    else
        return b;
    end
end




function setSwitchDoorOpenOrClosed(obj_nr, openOrNot)
--   called by handleSignDoorRaetsel(), this fkt opens or closes a door
--    Sets door-status (0=closed, 1=open) and if the door should be blocking, visible and onTop
--   Parameter:
--    obj_nr is the Number of the door that will be opend or closed,
--    openOrNot is 1 for "open door now" or 0 for "please close that door now"
--   Returns: "play_sound"-code, used in handleSignDoorRaetsel() to know, what kind of
--    sound should be played at end of fkt handleSignDoorRaetsel() (1: play sound "door open", 2: play sound "door closed")
    STATUS_SIGN_DOOR[obj_nr]  = openOrNot;
    SetBlocking(OBJ_SIGN_DOOR[obj_nr], 1-openOrNot);
    SetVisible(OBJ_SIGN_DOOR[obj_nr], 1-openOrNot);
    SetOnTop(OBJ_SIGN_DOOR[obj_nr], 1-openOrNot);
    return 2-openOrNot;
end
