///////////////////////////////////////////////////////////////////////////
/*
  Copyright 2001 Ronald S. Burkey

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	gztest.c
  Purpose:	This just reads a gzipped GutenMark wordlist, and dumps
  		it.  It's not really useful.  It's more of a proof of
		concept that I can read the gzipped files directly without
		unzipping them first.
  Mods:		11/09/01 RSB	Began.
*/
///////////////////////////////////////////////////////////////////////////

/*
  This is just a little test to make sure I can read a gzipped
  file the way I think I can.
*/

#include <stdio.h>
#include <zlib.h>

char s[1000];

int
main (int argc, char *argv[])
{
  gzFile fp;
  if (argc < 2)
    {
      printf ("Usage:\tgztest gzippedfile >gunzippedfile\n");
      return (2);
    }
  fp = gzopen (argv[1], "r");
  if (fp == NULL)
    {
      printf ("Cannot open file\n");
      return (1);
    }
  while (Z_NULL != gzgets (fp, s, sizeof (s) - 1))
    printf ("%s", s);
  gzclose (fp);
  return (0);
}
