///////////////////////////////////////////////////////////////////////////
/*
  Copyright 2001 Ronald S. Burkey

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	USGS.c
  Purpose:	This program is used to process USGS geographical
  		database files (in columnar format) to produce GutenMark
		compatible wordlists.  Only placenames consisting of a
		single word are retained by this program.
  Mods:		12/18/01 RSB	Began.
  
  This conversion is exceedingly simple.  The placenames are contained
  in columns 4-53, and are in the correct case.  Unfortunately, a few
  place names have non-alphabetic symbols in them like ' / : - (and maybe
  others), but there's no explanation of the interpretation of these, 
  so we have to discard names with these special symbols in them.
*/
///////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>
#include <ctype.h>

char s[1000], ss[60], Name[60], *sss;

int
main (void)
{
  while (NULL != fgets (s, sizeof (s), stdin))
    {
      s[52] = 0;
      if (1 == sscanf (&s[3], "%s%s", Name, ss))
	{
	  for (sss = Name; *sss; sss++)
	    if (!isalpha (*sss))
	      break;
	  if (!*sss)
	    printf ("%s\n", Name);
	}
    }
  return (0);
}
