// -*- C++ -*- generated by wxGlade 0.6.3 on Sat Apr 19 19:36:23 2008
/*
  Copyright 2008 Ronald S. Burkey <info@sandroid.org>

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	GUItenMark.cpp
  Purpose:	This file contains the GUI event handlers for GUItenMark.
  Mods:		04/18/2008 RSB	Began.
  		04/21/2008 RSB	I'd cautiously say, "It's working."
		05/29/2008 RSB	Added stuff related to GutenSplit.
  
  This file is partially generated by wxGlade from GUItenMark.wxg.
  (Of course, I wrote GUItenMark.wxg and there's no way to embed any
  copyright or licensing info in it, but I assert the same copyright
  and licensing for it as for this file.  Conversely, even though 
  this file is partially machine-generated, it is generated from 
  my instructions in GUItenMark.wxg, so I can assert copyright.)  
  However, this section of the file is not overwritten, and is 
  maintained manually.
*/

#include "GUItenMark.h"

// begin wxGlade: ::extracode
// end wxGlade



MyFrame::MyFrame(wxWindow* parent, int id, const wxString& title, const wxPoint& pos, const wxSize& size, long style):
    wxFrame(parent, id, title, pos, size, wxDEFAULT_FRAME_STYLE)
{
    // begin wxGlade: MyFrame::MyFrame
    label_2 = new wxStaticText(this, wxID_ANY, wxT("Input Files"));
    const wxString *InputFiles_choices = NULL;
    InputFiles = new wxListBox(this, ID_INPUT_FILES, wxDefaultPosition, wxDefaultSize, 0, InputFiles_choices, 0);
    button_2 = new wxButton(this, ID_ADD_FILES, wxT("Add files"));
    ClearInputList = new wxButton(this, ID_CLEAR_INPUT_LIST, wxT("Clear list"));
    AuthorLabel = new wxStaticText(this, ID_AUTHOR_LABEL, wxT("Override author's name:"));
    AuthorOverride = new wxTextCtrl(this, ID_OVERRIDE_AUTHOR, wxEmptyString);
    TitleLabel = new wxStaticText(this, ID_TITLE_LABEL, wxT("Override title:"));
    TitleOverride = new wxTextCtrl(this, ID_OVERRIDE_TITLE, wxEmptyString);
    ConvertTexts = new wxBitmapButton(this, ID_CONVERT_TEXTS, wxBitmap(wxT("./convert.jpg"), wxBITMAP_TYPE_ANY));
    label_3 = new wxStaticText(this, wxID_ANY, wxT("Output Files"));
    const wxString *OutputFiles_choices = NULL;
    OutputFiles = new wxListBox(this, ID_OUTPUT_FILES, wxDefaultPosition, wxDefaultSize, 0, OutputFiles_choices, 0);
    ClearOutputList = new wxButton(this, ID_CLEAR_OUTPUT_LIST, wxT("Clear list"));
    Populate = new wxButton(this, ID_POPULATE, wxT("Populate"));
    label_8 = new wxStaticText(this, wxID_ANY, wxT("Output folder:"));
    OutputFolder = new wxTextCtrl(this, ID_OUTPUT_FOLDER, wxEmptyString);
    button_9 = new wxButton(this, ID_OUTPUT_FOLDER_BROWSE, wxT("Browse"));
    static_line_2 = new wxStaticLine(this, wxID_ANY);
    label_1 = new wxStaticText(this, wxID_ANY, wxT("Settings"));
    AllCapsOk = new wxCheckBox(this, ID_ALL_CAPS_OK, wxT("ALL CAPS ok?"));
    RestoreDiacrits = new wxCheckBox(this, ID_RESTORE_DIACRITS, wxT("Restore diacrits?"));
    RaggedRightMargin = new wxCheckBox(this, ID_RAGGED_RIGHT, wxT("Ragged right margin?"));
    HtmlOutput = new wxRadioButton(this, ID_HTML_OUTPUT, wxT("HTML output?"));
    RunGutenSplit = new wxCheckBox(this, ID_GUTENSPLIT, wxT("Split at headings?"));
    LatexOutput = new wxRadioButton(this, ID_LATEX_OUTPUT, wxT("LaTeX output?"));
    FirstWordAllCapsOk = new wxCheckBox(this, ID_FIRST_WORD_ALL_CAPS, wxT("1st word ALL-CAPS ok?"));
    ItalicizeNonEnglish = new wxCheckBox(this, ID_ITALICIZE_FOREIGN, wxT("Italicize foreign words?"));
    PreserveStringsOfHyphens = new wxCheckBox(this, ID_PRESERVE_STRINGS_OF_HYPHENS, wxT("Preserve hyphens strings?"));
    HtmlUseSymbolicEntities = new wxCheckBox(this, ID_USE_SYMBOLIC_ENTITIES, wxT("Use symbolic entities?"));
    LevelOne = new wxCheckBox(this, ID_LEVEL1, wxT("H1"));
    LevelTwo = new wxCheckBox(this, ID_LEVEL2, wxT("H2"));
    LevelThree = new wxCheckBox(this, ID_LEVEL3, wxT("H3"));
    LevelFour = new wxCheckBox(this, ID_LEVEL4, wxT("H4"));
    LatexSectionMarkup = new wxCheckBox(this, ID_LATEX_SECTIONS, wxT("Use \"section*\" markup?"));
    FirstWordItalicsOk = new wxCheckBox(this, ID_FIRST_WORD_ITALICS, wxT("1st word italics ok?"));
    SingleSpaceBetweenSentences = new wxCheckBox(this, ID_SINGLE_SPACE_BETWEEN_SENTENCES, wxT("Single space after period?"));
    HtmlAddPrefatoryMarks = new wxCheckBox(this, ID_ADD_PREFATORY_MARKS, wxT("Add \"prefatory\" marks?"));
    SkipFirstHeading = new wxCheckBox(this, ID_SKIP_FIRST_HEADING, wxT("Split at first?"));
    LatexIndentParagraphs = new wxCheckBox(this, ID_INDENT_PARAGRAPHS, wxT("Indent paragraphs?"));
    Debug = new wxCheckBox(this, ID_DEBUG, wxT("Create logfiles?"));
    RonsOptions = new wxCheckBox(this, ID_RONS_OPTIONS, wxT("Ron's options"));
    RetainProjectGutenbergHeader = new wxCheckBox(this, ID_RETAIN_PG_HEADER, wxT("Retain PG header?"));
    HtmlAddPageBreakMarks = new wxCheckBox(this, ID_ADD_PAGE_BREAK_MARKS, wxT("Add page-break marks?"));
    TableOfContents = new wxCheckBox(this, ID_TOC, wxT("Table of contents?"));
    LatexEliminateToc = new wxCheckBox(this, ID_ELIMINATE_TOC, wxT("Eliminate T.O.C.?"));
    label_6 = new wxStaticText(this, wxID_ANY, wxT("Override default configuration file:"));
    ConfigurationFile = new wxTextCtrl(this, ID_CONFIGURATION_FILE, wxEmptyString);
    button_5 = new wxButton(this, ID_BROWSE_CONFIGURATION_FILES, wxT("Browse"));
    label_7 = new wxStaticText(this, wxID_ANY, wxT("Profile:"));
    const wxString *Profile_choices = NULL;
    Profile = new wxChoice(this, ID_PROFILE, wxDefaultPosition, wxDefaultSize, 0, Profile_choices, 0);
    static_line_1 = new wxStaticLine(this, wxID_ANY);
    button_6 = new wxButton(this, ID_SAVE_SETTINGS, wxT("Save settings"));
    button_7 = new wxButton(this, ID_RESTORE_SETTINGS, wxT("Restore settings"));
    button_1 = new wxButton(this, ID_DEFAULT_SETTINGS, wxT("Default settings"));
    button_8 = new wxButton(this, ID_GOODBYE, wxT("Goodbye!"));

    set_properties();
    do_layout();
    // end wxGlade
}


BEGIN_EVENT_TABLE(MyFrame, wxFrame)
    // begin wxGlade: MyFrame::event_table
    EVT_LISTBOX_DCLICK(ID_INPUT_FILES, MyFrame::ClickInputFile)
    EVT_BUTTON(ID_ADD_FILES, MyFrame::ClickAddFiles)
    EVT_BUTTON(ID_CLEAR_INPUT_LIST, MyFrame::ClickClearInputFiles)
    EVT_BUTTON(ID_CONVERT_TEXTS, MyFrame::ClickConvertTexts)
    EVT_LISTBOX_DCLICK(ID_OUTPUT_FILES, MyFrame::ClickOutputFile)
    EVT_BUTTON(ID_CLEAR_OUTPUT_LIST, MyFrame::ClickClearOutputList)
    EVT_BUTTON(ID_POPULATE, MyFrame::ClickPopulate)
    EVT_BUTTON(ID_OUTPUT_FOLDER_BROWSE, MyFrame::ClickOutputFolderBrowse)
    EVT_RADIOBUTTON(ID_HTML_OUTPUT, MyFrame::ClickHtmlOutput)
    EVT_CHECKBOX(ID_GUTENSPLIT, MyFrame::SplitCheck)
    EVT_RADIOBUTTON(ID_LATEX_OUTPUT, MyFrame::ClickLatexOutput)
    EVT_CHECKBOX(ID_INDENT_PARAGRAPHS, MyFrame::ClickLatexIndentParagraphs)
    EVT_CHECKBOX(ID_RONS_OPTIONS, MyFrame::ClickRon)
    EVT_TEXT_ENTER(ID_CONFIGURATION_FILE, MyFrame::NewConfigurationFiles)
    EVT_BUTTON(ID_BROWSE_CONFIGURATION_FILES, MyFrame::ClickConfigurationFileBrowse)
    EVT_CHOICE(ID_PROFILE, MyFrame::ClickProfile)
    EVT_BUTTON(ID_SAVE_SETTINGS, MyFrame::ClickSaveSettings)
    EVT_BUTTON(ID_RESTORE_SETTINGS, MyFrame::ClickRestoreSettings)
    EVT_BUTTON(ID_DEFAULT_SETTINGS, MyFrame::ClickDefaultSettings)
    EVT_BUTTON(ID_GOODBYE, MyFrame::ClickGoodbye)
    // end wxGlade
    EVT_CLOSE (MyFrame::OnClose)
END_EVENT_TABLE();



// wxGlade: add MyFrame event handlers


void MyFrame::set_properties()
{
    // begin wxGlade: MyFrame::set_properties
    SetTitle(wxT("GUItenMark, (c)2008 Ron Burkey"));
    wxIcon _icon;
    _icon.CopyFromBitmap(wxBitmap(wxT("./logo.jpg"), wxBITMAP_TYPE_ANY));
    SetIcon(_icon);
    label_2->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    InputFiles->SetToolTip(wxT("A list of etext files which will be converted to HTML or LaTeX."));
    button_2->SetToolTip(wxT("Add files to the list above, to make them eligible for conversion."));
    ClearInputList->SetToolTip(wxT("Clear the list of input files above."));
    AuthorLabel->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    AuthorOverride->SetToolTip(wxT("By default, the author's name is deduced from the etext file.  If instead you put a name here, it will be applied to all of the etext files in the list above, and override any author names within the file(s)."));
    TitleLabel->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    TitleOverride->SetToolTip(wxT("By default, book titles are deduced from the input etext.  You can, however, override this by putting a title here.  This makes sense only if there is a single input text in the list above."));
    ConvertTexts->SetToolTip(wxT("Convert texts listed at the left to HTML or LaTeX."));
    ConvertTexts->SetSize(ConvertTexts->GetBestSize());
    label_3->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    OutputFiles->SetToolTip(wxT("A list of all the etexts that have been converted in this session."));
    ClearOutputList->SetToolTip(wxT("Clear the list of output files above."));
    Populate->SetToolTip(wxT("Populates the Output Files list from all of the *.html and *.tex file found in the specified output folder.  There's no necessity whatsoever to do this, but it's a convenient way to see what files you've converted in previous sessions and/or to browse the files by double-clicking on them."));
    label_8->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    OutputFolder->SetToolTip(wxT("If you don't like the default folder in which the output files will be stored, put the name of another folder here."));
    button_9->SetToolTip(wxT("Browse for a new output folder."));
    label_1->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    AllCapsOk->SetToolTip(wxT("By default, words or phrases in ALL-CAPS are turned into italics (unless they are known ALL-CAPS acronyms).  If you want to leave ALL-CAPS words as-is, use this option."));
    RestoreDiacrits->SetToolTip(wxT("By default, an attempt will be made to restore missing diacrits, such as umlauts, accents, etc., as well as ligatures like ae or oe.  If you want to disable this feature, use this option."));
    RaggedRightMargin->SetToolTip(wxT("By default, text is right justified (except for the last lines of paragraphs).  If you would prefer a ragged-right edge, use this option."));
    HtmlOutput->SetToolTip(wxT("Output the edited etext in HTML format, for use with browsers."));
    RunGutenSplit->SetToolTip(wxT("Click this button to split HTML output files into separate files where headings occur."));
    LatexOutput->SetToolTip(wxT("Output the edited etext in LaTeX format, for typesetting."));
    FirstWordAllCapsOk->SetToolTip(wxT("By default, words which are in ALL-CAPS are converted to italicized words.  If this option is chosen, the first word of every chapter is allowed to remain in ALL-CAPS (assuming that it was in ALL-CAPS in the input file)."));
    ItalicizeNonEnglish->SetToolTip(wxT("By default, an attempt is made to identify words or phrases foreign to English, and to italicize them.  If you want to disable this feature, use this option."));
    PreserveStringsOfHyphens->SetToolTip(wxT("By default, strings of hyphens such as \"--\" or \"---\" are converted to long dashes (\"m-dashes\").  If you would prefer to leave such strings of options as-is, use this option."));
    HtmlUseSymbolicEntities->SetToolTip(wxT("This option is of interest only to software developers.  It causes \"entities\" for special characters to be output in symbolic format (such as \"&mdash;\") rather than numerical format (\"&#nnnn;\")."));
    LevelOne->SetFont(wxFont(14, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    LevelOne->SetToolTip(wxT("Split at the highest-level headings."));
    LevelTwo->SetFont(wxFont(12, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    LevelTwo->SetToolTip(wxT("Split at the secondary headings."));
    LevelThree->SetFont(wxFont(11, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    LevelThree->SetToolTip(wxT("Split at the third level of headings."));
    LevelFour->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    LevelFour->SetToolTip(wxT("Split at the lowest level of headings."));
    LatexSectionMarkup->SetToolTip(wxT("With this option, LaTeX \"section*\" marks instead of \"chapter*\" marks are used to identify chapters."));
    LatexSectionMarkup->Enable(false);
    FirstWordItalicsOk->SetToolTip(wxT("By default, if the first word in a chapter is italicized, then it is turned into normal text.  If you want to disable this conversion and leave such words as-is, use this option."));
    SingleSpaceBetweenSentences->SetToolTip(wxT("By default, two spaces are used between sentences.  If you would prefer a single space, use this option."));
    HtmlAddPrefatoryMarks->SetToolTip(wxT("This option allows the addition of invisible comments marking the location of the \"prefatory material\" to HTML output.  These marks can be useful if the HTML is post-processed by software that can interpret the marks."));
    SkipFirstHeading->SetToolTip(wxT("If checked, a split is made at the very first heading encountered."));
    LatexIndentParagraphs->SetToolTip(wxT("By default, paragraphs are separated by a single blank line and have the first word lined up with the left margin.  If this option is used, paragraphs have no separating space, and their initial words are indented according to normal publishing practice."));
    LatexIndentParagraphs->Enable(false);
    Debug->SetToolTip(wxT("This option merely causes the creation of logfiles which can be used for debugging purposes.  These logs aren't useful to most people, so the default is not to create them."));
    RonsOptions->SetToolTip(wxT("This option activates a combination of options I (Ron Burkey, the creator of these programs) have found useful.  You won't find them useful, but it's my program and I'll put in any options I like!  :-)"));
    RetainProjectGutenbergHeader->SetToolTip(wxT("By default, Project Gutenberg headers are removed form the etext and replaced by short GutenMark messages.  With this option, the Project Gutenberg headers are retained."));
    HtmlAddPageBreakMarks->SetToolTip(wxT("This option allows page-breaks to be marked within HTML output by means of invisible comments.  These marks can be useful if the HTML is post-processed by software that can interpret the marks."));
    TableOfContents->SetToolTip(wxT("Should a separate table-of-contents page be created?"));
    LatexEliminateToc->SetToolTip(wxT("By default, LaTeX output files contain a table of contents.  This option deletes the table of contents."));
    LatexEliminateToc->Enable(false);
    label_6->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    ConfigurationFile->SetToolTip(wxT("If you have a customized GutenMark configuration file that you want to use instead of the default configuration, enter its full pathname here."));
    button_5->SetToolTip(wxT("Browse to find a configuration file."));
    label_7->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    Profile->SetToolTip(wxT("Select a profile (language) from a list of those provided by the configuration file."));
    button_6->SetToolTip(wxT("Save the settings above, so that they'll be available if you run GUItenMark again later."));
    button_7->SetToolTip(wxT("Restore settings that have been saved previously."));
    button_8->SetToolTip(wxT("End the GUItenMark program."));
    // end wxGlade
}


void MyFrame::do_layout()
{
    // begin wxGlade: MyFrame::do_layout
    wxBoxSizer* sizer_1 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_2 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_3 = new wxBoxSizer(wxHORIZONTAL);
    wxGridSizer* grid_sizer_1 = new wxGridSizer(4, 6, 0, 0);
    wxBoxSizer* sizer_12 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_4 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_6 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_10 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_11 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_5 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_9 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_7 = new wxBoxSizer(wxHORIZONTAL);
    sizer_5->Add(label_2, 0, wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 0);
    sizer_5->Add(InputFiles, 1, wxLEFT|wxEXPAND|wxADJUST_MINSIZE, 5);
    sizer_7->Add(button_2, 0, wxRIGHT|wxADJUST_MINSIZE, 15);
    sizer_7->Add(ClearInputList, 0, wxLEFT|wxADJUST_MINSIZE, 15);
    sizer_5->Add(sizer_7, 0, wxTOP|wxBOTTOM|wxALIGN_CENTER_HORIZONTAL, 10);
    sizer_8->Add(AuthorLabel, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 10);
    sizer_8->Add(AuthorOverride, 1, wxEXPAND|wxADJUST_MINSIZE, 0);
    sizer_5->Add(sizer_8, 0, wxTOP|wxBOTTOM|wxEXPAND, 5);
    sizer_9->Add(TitleLabel, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 10);
    sizer_9->Add(TitleOverride, 1, wxEXPAND|wxADJUST_MINSIZE, 0);
    sizer_5->Add(sizer_9, 0, wxTOP|wxBOTTOM|wxEXPAND, 5);
    sizer_4->Add(sizer_5, 1, wxEXPAND, 0);
    sizer_4->Add(ConvertTexts, 0, wxLEFT|wxRIGHT|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 20);
    sizer_6->Add(label_3, 0, wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 0);
    sizer_6->Add(OutputFiles, 1, wxRIGHT|wxEXPAND|wxADJUST_MINSIZE, 5);
    sizer_11->Add(ClearOutputList, 0, wxRIGHT|wxADJUST_MINSIZE, 15);
    sizer_11->Add(Populate, 0, wxLEFT|wxADJUST_MINSIZE, 15);
    sizer_6->Add(sizer_11, 0, wxTOP|wxBOTTOM|wxALIGN_CENTER_HORIZONTAL, 10);
    sizer_10->Add(label_8, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 10);
    sizer_10->Add(OutputFolder, 1, wxEXPAND|wxADJUST_MINSIZE, 0);
    sizer_10->Add(button_9, 0, wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);
    sizer_6->Add(sizer_10, 0, wxTOP|wxEXPAND, 5);
    sizer_4->Add(sizer_6, 1, wxEXPAND, 0);
    sizer_1->Add(sizer_4, 1, wxLEFT|wxRIGHT|wxEXPAND, 5);
    sizer_1->Add(static_line_2, 0, wxTOP|wxBOTTOM|wxEXPAND, 10);
    sizer_1->Add(label_1, 0, wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 5);
    grid_sizer_1->Add(AllCapsOk, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(RestoreDiacrits, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(RaggedRightMargin, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(HtmlOutput, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(RunGutenSplit, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(LatexOutput, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(FirstWordAllCapsOk, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(ItalicizeNonEnglish, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(PreserveStringsOfHyphens, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(HtmlUseSymbolicEntities, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_12->Add(LevelOne, 1, wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_12->Add(LevelTwo, 1, wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_12->Add(LevelThree, 1, wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_12->Add(LevelFour, 1, wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(sizer_12, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_1->Add(LatexSectionMarkup, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(FirstWordItalicsOk, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(20, 20, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(SingleSpaceBetweenSentences, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(HtmlAddPrefatoryMarks, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(SkipFirstHeading, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(LatexIndentParagraphs, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(Debug, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(RonsOptions, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(RetainProjectGutenbergHeader, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(HtmlAddPageBreakMarks, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(TableOfContents, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    grid_sizer_1->Add(LatexEliminateToc, 0, wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    sizer_1->Add(grid_sizer_1, 0, wxLEFT|wxTOP|wxBOTTOM|wxEXPAND, 5);
    sizer_3->Add(label_6, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 10);
    sizer_3->Add(ConfigurationFile, 3, wxRIGHT|wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 5);
    sizer_3->Add(button_5, 0, wxRIGHT|wxADJUST_MINSIZE, 20);
    sizer_3->Add(label_7, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 10);
    sizer_3->Add(Profile, 2, wxEXPAND|wxADJUST_MINSIZE, 0);
    sizer_1->Add(sizer_3, 0, wxALL|wxEXPAND, 5);
    sizer_1->Add(static_line_1, 0, wxTOP|wxBOTTOM|wxEXPAND, 15);
    sizer_2->Add(button_6, 0, wxADJUST_MINSIZE, 0);
    sizer_2->Add(button_7, 0, wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 20);
    sizer_2->Add(button_1, 0, wxADJUST_MINSIZE, 0);
    sizer_2->Add(100, 20, 0, wxADJUST_MINSIZE, 0);
    sizer_2->Add(button_8, 0, wxADJUST_MINSIZE, 0);
    sizer_1->Add(sizer_2, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxALIGN_CENTER_HORIZONTAL, 10);
    SetSizer(sizer_1);
    sizer_1->Fit(this);
    Layout();
    // end wxGlade
}













































