/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc.
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
###
*/

#include "all.h"

//Show current XIM styles
void HZshowXIMStyles(){

	IC *ic = (IC *)FindIC(last_icid);

	//print out the input style of this ic
	if(ic->input_style & XIMPreeditNothing) 
		printf("XIMPreeditNothing");
	else if(ic->input_style & XIMPreeditPosition)
		printf("XIMPreeditPosition");
	else if(ic->input_style & XIMPreeditCallbacks)
		printf("XIMPreeditCallbacks");
	else if(ic->input_style & XIMPreeditNone)
		printf("XIMPreeditNone");
	else if(ic->input_style & XIMPreeditArea)
		printf("XIMPreeditArea");
	printf("|");

	if(ic->input_style & XIMStatusNothing)
		printf("XIMStatusNothing");
	else if(ic->input_style & XIMStatusArea)
		printf("XIMStatusArea");
	else if(ic->input_style & XIMStatusCallbacks)
		printf("XIMStatusCallbacks");
	else if(ic->input_style & XIMStatusNone)
		printf("XIMStatusNone");
	printf("\n");
}

int get_dmode(IC *ic)
{
	if(ic->input_style & XIMPreeditCallbacks)
		return HZSERVER_DMODE_ONSPOT;
	else if(ic->input_style & XIMPreeditPosition)
		return HZSERVER_DMODE_OVERSPOT;
	else if(ic->input_style & XIMPreeditArea)
		return HZSERVER_DMODE_OFFSPOT;
	else if(ic->input_style & XIMPreeditNothing)
		return HZSERVER_DMODE_ROOT;
	return -1;
}

//when focus in, set the current ic
//current_focus_ic is used to judge if the request is
//from the current window
Boolean HZprocFocusIn(IMChangeFocusStruct *call_data)
{
	IC *ic;

	ic = (IC *)FindIC(call_data->icid);
	if(!ic) return True;

	if(last_icid){
		IC *tic = (IC *)FindIC(last_icid);;
		if(tic && tic->input_style & XIMStatusArea)
			HZoffspotHideStatusWindow(tic);
	}


	last_icid = call_data->icid;
	last_connectid = call_data->connect_id;


	prev_dmode = get_dmode(ic);

	//record current ic and encoding
	current_focus_ic = ic;
	flag_encoding = ic->encoding;

	//change the toolbar status, mainly encoding of client.
	HZnotifyToolbar();

#if 0
	HZshowXIMStyles(ic);
#endif

	if(flag_automode == True){
		//set input server's display mode
		if((ic->input_style & XIMPreeditPosition) &&
	   	   ((ic->input_style & XIMStatusNothing) ||
	    	    (ic->input_style & XIMStatusArea)    ||
	    	    (ic->input_style & XIMStatusNone))){
			//printf("set to caret mode\n");
			//HZprocSetMode(HZSERVER_DMODE_OVERSPOT);
			dmode = HZSERVER_DMODE_OVERSPOT;
		} else 
		if((ic->input_style & XIMPreeditArea) &&
	   	   ((ic->input_style & XIMStatusArea)    ||
	    	    (ic->input_style & XIMStatusNothing) ||
	    	    (ic->input_style & XIMStatusNone))){
			//printf("set to offspot mode\n");
			//HZprocSetMode(HZSERVER_DMODE_OFFSPOT);
			dmode = HZSERVER_DMODE_OFFSPOT;
		} else
		if((ic->input_style & XIMPreeditNothing) && 
	   	   ((ic->input_style & XIMStatusNothing) ||
	    	    (ic->input_style & XIMStatusNone))){
			//printf("set to root mode\n");
			//HZprocSetMode(HZSERVER_DMODE_ROOT);
			dmode = HZSERVER_DMODE_ROOT;
		} else 
		if((ic->input_style & XIMPreeditCallbacks) &&
	   	   ((ic->input_style & XIMStatusArea)    ||
	    	    (ic->input_style & XIMStatusCallbacks)    ||
	    	    (ic->input_style & XIMStatusNothing) ||
	    	    (ic->input_style & XIMStatusNone))){
			//printf("set to onspot mode\n");
			//HZprocSetMode(HZSERVER_DMODE_ONSPOT);
			dmode = HZSERVER_DMODE_ONSPOT;
		}
	}

	HZprocSetMode(dmode);

	if(dmode == HZSERVER_DMODE_ONSPOT){
		HZprocSetMode(HZSERVER_DMODE_ONSPOT);

		//for onthespot style, the server should
		//clear the previous input buffer before other operation
		HZonspotPreeditClear();
	} else if(dmode == HZSERVER_DMODE_OFFSPOT){
		//if the areas are controlled by the client,
		//the reset the background and foreground of drawing gc
    		if(flag_client == HZSERVER_AREAMODE_CLIENT){
			if(ic->sts_attr.foreground == ic->sts_attr.background){
				ic->sts_attr.foreground = WhitePixel(display, screen_num);
				ic->sts_attr.background = BlackPixel(display, screen_num);
			}
				
        		XSetForeground(display, offspot_gc, ic->sts_attr.foreground);
        		XSetBackground(display, offspot_gc, ic->sts_attr.background);
        		XSetForeground(display, offspot_bggc, ic->sts_attr.background);
        		XSetBackground(display, offspot_bggc, ic->sts_attr.foreground);
        		XSetForeground(display, offspot_gbgc, ic->sts_attr.foreground);
        		XSetBackground(display, offspot_gbgc, ic->sts_attr.background);
        		XSetForeground(display, offspot_big5gc, ic->sts_attr.foreground);
        		XSetBackground(display, offspot_big5gc, ic->sts_attr.background);
    		}
		if(map_mode == 0)HZoffspotHideWindows();
	} else if(dmode == HZSERVER_DMODE_OVERSPOT){
		if(map_mode == 1)HZoverspotSetLocation(ic);
		else HZoffspotHideStatusWindow(ic);
	}

	//flush all
	if(map_mode == 1){
		if(dmode == HZSERVER_DMODE_ROOT)
			HZrootFlush();
		else if(dmode == HZSERVER_DMODE_OVERSPOT)
			HZoverspotFlush();
		else if(dmode == HZSERVER_DMODE_ONSPOT)
			HZonspotFlush();
		else if(dmode == HZSERVER_DMODE_OFFSPOT)
			HZoffspotFlush();
	}

	return True;
}


Boolean HZprocFocusOut(IMChangeFocusStruct *call_data)
{
	//for onthe spot style, clear the preedit area
        IC *ic;

        last_icid = call_data->icid;
        last_connectid = call_data->connect_id;
        ic = (IC *)FindIC(call_data->icid);

	if((ic->input_style & XIMPreeditCallbacks) &&
	   ((ic->input_style & XIMStatusArea)    ||
	    (ic->input_style & XIMStatusCallbacks)    ||
	    (ic->input_style & XIMStatusNothing) ||
	    (ic->input_style & XIMStatusNone))){
		HZonspotPreeditClear();
	}
	return True;
}

Boolean HZprocResetIC(IMResetICStruct *call_data)
{
	//IC *ic;
	//ic = (IC *)FindIC(call_data->icid);
	return True;
}

//After strings committed , set the current ic,
//this is useful for caret mode
void HZprocSetCurrentIC(IMForwardEventStruct *call_data)
{
	IC *ic;

	if(flag_automode == False) return;

	ic = (IC *)FindIC(call_data->icid);
	if(ic != NULL) current_focus_ic = ic;

	//for mozilla, no focus in event, so we have to check
	//input style every time when ic is reset
	dmode = get_dmode(ic);
	if(dmode != prev_dmode){
		prev_dmode = dmode;
		//switch to dmode
		HZprocSetMode(dmode);
	}
}

void HZprocAutoHide(void)
{
	if(hmode == HZSERVER_HMODE_AUTO)
		hmode = HZSERVER_HMODE_NO;
	else
		hmode = HZSERVER_HMODE_AUTO;
}


