/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

/*
 * Copyright 1997 by Yu Mingjian.          All Rights Reserved
 * Distributed under the terms of the GNU General Public License (GPL)
 *
 * Permission to retain, use, modify, copy, and distribute Chinput1.0
 * in source or binary and its documentation (hereafter, the Software)
 * for noncommercial purpose is hereby granted to you without a fee,
 * provided that this entire copyright and permission notice appear in
 * all such copies, that no charge be associated with such copies,
 * that distribution of derivative works (including value-added
 * distributions such as with additional input dictionaries or fonts)
 * include clarification that such added or derived parts are not from
 * the original Software, and that the names of the author(s) not be
 * used to endorse or promote such works. The author(s) of the software
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE AUTHOR(S) OF THE SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR(S) OF THE SOFTWARE BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Yu Mingjian, Institute of High Energy Physics, Academia Sinica
 * 
 */

// I am the main program, I own all the globals

#define   MAIN_PROGRAM
#include "all.h"
#undef    MAIN_PROGRAM

//locale now set by environment
void usage(void)
{

        printf("Usage: chinput [options]\n");
        printf("             -gb       -- enable GB encoding.\n");
        printf("             -big5     -- enable BIG5 encoding.\n");
	printf("             -root     -- Root window Style.\n");
	printf("             -overspot -- OverTheSpot style.\n");
	printf("             -onspot   -- OnTheSpot style.\n");
	printf("             -offspot  -- OffTheSpot style.\n");
        exit(0);
}

int main(int argc, char **argv)
{
	HZserverInfo();				//print out server information
	HZcheckInput();				//check ZNPY user dict
	HZinitResource();			//internal resource init
	HZloadRCFile();				//resource file
	HZloadRCIME();				//IME lists from Chinput.ad
	HZparseParameters(argc, argv);		//parse parameters
	setlocale(LC_ALL, deflocale);		//locale set
	HZinitDisplay();			//display init
	HZinitServerFont();			//font init
	HZinitWindows();			//windows geometry init
	HZinitControlBar();			//control bar init
	HZinitXIM();				//xim init
	HZinitServerAtom();			//atom init
	HZinitServerGC();			//font set
	HZinitIcons();				//load icons(imlib only)
	HZinitHWEngine();			//handwriting init
	HZinitVoiceRecognition();		//IBM ViaVoice init
	HZinitIME();				//input method init
	HZinitDaemon();				//become a daemon
	HZenterLoop();				//event processing

	//never reach here, but make compiler happy
	return 0;
}

