/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc.
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

/******************************************************************
 
         Copyright 1994, 1995 by Sun Microsystems, Inc.
         Copyright 1993, 1994 by Hewlett-Packard Company
 
Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
and Hewlett-Packard not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.
Sun Microsystems, Inc. and Hewlett-Packard make no representations about
the suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
 
SUN MICROSYSTEMS INC. AND HEWLETT-PACKARD COMPANY DISCLAIMS ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SUN MICROSYSTEMS, INC. AND HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 
  Author: Hidetoshi Tajima(tajima@Eng.Sun.COM) Sun Microsystems, Inc.
 
******************************************************************/

#include "all.h"

static IC *ic_list = (IC *)NULL;
static IC *free_list = (IC *)NULL;

static IC *NewIC()
{
    static CARD16 icid = 0;
    IC *rec;

    if (free_list != NULL) {
	rec = free_list;
	free_list = free_list->next;
    } else {
	rec = (IC *)malloc(sizeof(IC));
    }
    memset(rec, 0, sizeof(IC));
    rec->id = ++icid;

    rec->next = ic_list;
    ic_list = rec;
    return rec;
}

IC *FindIC(CARD16 icid)
{
    IC *rec = ic_list;

    while (rec != NULL) {
	if (rec->id == icid)
	  return rec;
	rec = rec->next;
    }

    return NULL;
}

int FindEnc(IMForwardEventStruct *call_data)
{
    IC *rec = ic_list;

    while (rec != NULL) {
        if (rec->id == call_data->icid)
          return rec->encoding;
        rec = rec->next;
    }

    return HZSERVER_ENCODING_GB;
}

int FindEncByID(int icid)
{
    IC *rec = ic_list;
    
    while (rec != NULL) {
        if (rec->id == icid)
          return rec->encoding;
        rec = rec->next;
    }   
    
    return HZSERVER_ENCODING_GB;
}

static void DeleteIC(CARD16 icid)
{
    IC *rec, *last;
    last = NULL;
    for (rec = ic_list; rec != NULL; last = rec, rec = rec->next) {
        if (rec->id == icid) {
          if (last != NULL)
            last->next = rec->next;
          else
            ic_list = rec->next;

          rec->next = free_list;
          free_list = rec;

	  //free resource
	  if (rec->resource_name)
        	free(rec->resource_name);
    	  if (rec->resource_class)
        	free(rec->resource_class);
	  if (rec->status_win) XDestroyWindow(display, rec->status_win);
	  if (rec->preedit_win) XDestroyWindow(display, rec->preedit_win);
/*
	  if (rec->pre_attr.gc) XFreeGC(display, rec->pre_attr.gc);
	  if (rec->sts_attr.gc) XFreeGC(display, rec->sts_attr.gc);
	  if (rec->pre_attr.fs) XFreeFontSet(display, rec->pre_attr.fs);
	  if (rec->sts_attr.fs) XFreeFontSet(display, rec->sts_attr.fs);
*/
          return;
	}
    }
    return;
}

static int Is(char *attr, XICAttribute *attr_list) {
	return !strcmp(attr, attr_list->name);
}

static void StoreIC(IC *rec, IMChangeICStruct *call_data)
{
	XICAttribute *ic_attr = call_data->ic_attr;
	XICAttribute *pre_attr = call_data->preedit_attr;
	XICAttribute *sts_attr = call_data->status_attr;
	register int i;
	for (i = 0; i < (int)call_data->ic_attr_num; i++, ic_attr++) {
		if (Is (XNInputStyle, ic_attr))
		    rec->input_style = *(INT32*)ic_attr->value;

		else if (Is (XNClientWindow, ic_attr)){
		    rec->client_win = *(Window*)ic_attr->value;
		}
		else if (Is (XNFocusWindow, ic_attr)){
		    rec->focus_win = *(Window*)ic_attr->value;
		}
		else 
		    fprintf(stderr, "Unknown attr: %s\n", ic_attr->name);
	}
	
	for (i = 0; i < (int)call_data->preedit_attr_num; i++, pre_attr++) {
		if (Is (XNArea, pre_attr)){
		    rec->pre_attr.area = *(XRectangle*)pre_attr->value;
#if 0
		    printf("Preedit Area: %d %d %d %d\n", 
			rec->pre_attr.area.x,
			rec->pre_attr.area.y,
			rec->pre_attr.area.width,
			rec->pre_attr.area.height);
#endif
		}
		else if (Is (XNAreaNeeded, pre_attr)){
		    rec->pre_attr.area_needed = *(XRectangle*)pre_attr->value;
#if 0
		    printf("Preedit Area Needed: %d %d %d %d\n", 
			rec->pre_attr.area.x,
			rec->pre_attr.area.y,
			rec->pre_attr.area_needed.width,
			rec->pre_attr.area_needed.height);
#endif
		}
		else if (Is (XNSpotLocation, pre_attr)){
		    rec->pre_attr.spot_location = *(XPoint*)pre_attr->value;
		    //if(rec == current_focus_ic && dmode == HZSERVER_DMODE_OVERSPOT)
		    if(dmode == HZSERVER_DMODE_OVERSPOT)
			HZoverspotSetLocation(rec);
		}
		
		else if (Is (XNColormap, pre_attr))
		    rec->pre_attr.cmap = *(Colormap*)pre_attr->value;
		
		else if (Is (XNStdColormap, pre_attr))
		    rec->pre_attr.cmap = *(Colormap*)pre_attr->value;
		
		else if (Is (XNForeground, pre_attr)){
		    rec->pre_attr.foreground = *(CARD32*)pre_attr->value;
		}
		else if (Is (XNBackground, pre_attr)){
		    rec->pre_attr.background = *(CARD32*)pre_attr->value;
		}
		else if (Is (XNBackgroundPixmap, pre_attr))
		    rec->pre_attr.bg_pixmap = *(Pixmap*)pre_attr->value;
		
		else if (Is (XNFontSet, pre_attr)) {
			int str_length = strlen(pre_attr->value);
			if (rec->pre_attr.base_font != NULL) {
				if (Is (rec->pre_attr.base_font, pre_attr))
					continue;
				XFree(rec->pre_attr.base_font);
			}
			rec->pre_attr.base_font = malloc(str_length + 1);
			strcpy(rec->pre_attr.base_font, pre_attr->value);
#if 0
			printf("fontset:%s-\n", rec->pre_attr.base_font);
#endif
		} else if (Is (XNLineSpace, pre_attr))
			    rec->pre_attr.line_space = *(CARD32*)pre_attr->value;
		
		else if (Is (XNCursor, pre_attr))
		    rec->pre_attr.cursor = *(Cursor*)pre_attr->value;

		else
		    fprintf(stderr, "Unknown attr: %s\n", ic_attr->name);
	}
	
	for (i = 0; i < (int)call_data->status_attr_num; i++, sts_attr++) {
		if (Is (XNArea, sts_attr)){
		    rec->sts_attr.area = *(XRectangle*)sts_attr->value;
#if 0
		    printf("Status Area: %d %d %d %d\n", 
			rec->sts_attr.area.x,
			rec->sts_attr.area.y,
			rec->sts_attr.area.width,
			rec->sts_attr.area.height);
#endif
		}
		else if (Is (XNAreaNeeded, sts_attr)){
		    rec->sts_attr.area_needed = *(XRectangle*)sts_attr->value;
#if 0
		    printf("Status Area Needed: %d %d %d %d\n", 
			rec->sts_attr.area.x,
			rec->sts_attr.area.y,
			rec->sts_attr.area_needed.width,
			rec->sts_attr.area_needed.height);
#endif
		}
		else if (Is (XNColormap, sts_attr)){
		    rec->sts_attr.cmap = *(Colormap*)sts_attr->value;
		}
		else if (Is (XNStdColormap, sts_attr))
		    rec->sts_attr.cmap = *(Colormap*)sts_attr->value;
		
		else if (Is (XNForeground, sts_attr)){
		    rec->sts_attr.foreground = *(CARD32*)sts_attr->value;
		}
		else if (Is (XNBackground, sts_attr)){
		    rec->sts_attr.background = *(CARD32*)sts_attr->value;
		}
		
		else if (Is (XNBackgroundPixmap, sts_attr))
		    rec->sts_attr.bg_pixmap = *(Pixmap*)sts_attr->value;
		
		else if (Is (XNFontSet, sts_attr)) {
			int str_length = strlen(sts_attr->value);
		
			if (rec->sts_attr.base_font != NULL) {
				if (Is (rec->sts_attr.base_font, sts_attr))
					continue;
				XFree(rec->sts_attr.base_font);
			}
			rec->sts_attr.base_font = malloc(str_length + 1);
			strcpy(rec->sts_attr.base_font, sts_attr->value);
#if 0
			printf("sts fontset:%s-\n", rec->sts_attr.base_font);
#endif

		} else if (Is (XNLineSpace, sts_attr))
			    rec->sts_attr.line_space= *(CARD32*)sts_attr->value;
		
		else if (Is (XNCursor, sts_attr))

		    rec->sts_attr.cursor = *(Cursor*)sts_attr->value;

		else 
		    fprintf(stderr, "Unknown attr: %s\n", ic_attr->name);
	}

	rec->encoding = xim_connect[call_data->connect_id];
}

void CreateIC(IMChangeICStruct *call_data)
{
    IC *rec;
/*
    char **missing_list;
    int  missing_count;
    char *def_string;
    char fsname[256];
*/
    rec = NewIC();
    if (rec == NULL)
      return;
    StoreIC(rec, call_data);
    call_data->icid = rec->id;
    rec->connect_id = call_data->connect_id;
    rec->len = 0;
    rec->sts_attr.area_needed.x = 0;
    rec->sts_attr.area_needed.y = FONT_HEIGHT;
    rec->sts_attr.area_needed.width = AREA_CHARS * FONT_WIDTH / 2;
    rec->sts_attr.area_needed.height = FONT_HEIGHT;
    rec->pre_attr.area_needed.x = 0;
    rec->pre_attr.area_needed.y = FONT_HEIGHT;
    rec->pre_attr.area_needed.width = AREA_CHARS * FONT_WIDTH / 2;
    rec->pre_attr.area_needed.height = FONT_HEIGHT;

    if(rec->input_style & XIMStatusArea)
	rec->status_win = create_win(0, 0, 1, 1);
    else
	rec->status_win = 0;
    if(rec->input_style & XIMPreeditArea)
	rec->preedit_win = create_win(0, 0, 1, 1);
    else
	rec->preedit_win = 0;
    rec->reparented = 0;

    //create gcs and fontsets
/*
    get_ColorGC(window1, &rec->pre_attr.gc, "#000000");
    get_ColorGC(window1, &rec->sts_attr.gc, "#000000");

    if((rec->pre_attr.fs = XCreateFontSet(display, 
	rec->pre_attr.base_font, &missing_list,
	&missing_count, &def_string)) == NULL) {
		sprintf(fsname, "%s,%s", font_latin, font_gb);
		rec->pre_attr.fs = XCreateFontSet(display,
        		fsname, &missing_list, &missing_count, &def_string);
    }
    if((rec->sts_attr.fs = XCreateFontSet(display, 
	rec->sts_attr.base_font, &missing_list,
	&missing_count, &def_string)) == NULL) {
		sprintf(fsname, "%s,%s", font_latin, font_gb);
		rec->sts_attr.fs = XCreateFontSet(display,
                	fsname, &missing_list, &missing_count, &def_string);
    }
*/
    return;
}

void DestroyIC(IMChangeICStruct *call_data)
{
    DeleteIC(call_data->icid);
    return;
}

void SetIC(IMChangeICStruct *call_data)
{
    IC *rec = FindIC(call_data->icid);
    if (rec == NULL)
      return;
    StoreIC(rec, call_data);

    return;
}

void GetIC(IMChangeICStruct *call_data)
{
    XICAttribute *ic_attr = call_data->ic_attr;
    XICAttribute *pre_attr = call_data->preedit_attr;
    XICAttribute *sts_attr = call_data->status_attr;
    register int i;
    IC *rec = FindIC(call_data->icid);
    if (rec == NULL)
      return;

    for (i = 0; i < (int)call_data->ic_attr_num; i++, ic_attr++) {
	if (Is (XNFilterEvents, ic_attr)) {
	    ic_attr->value = (void *)malloc(sizeof(CARD32));
	    *(CARD32*)ic_attr->value = KeyPressMask|KeyReleaseMask;
	    ic_attr->value_length = sizeof(CARD32);
	}
    }

    /* preedit attributes */
    for (i = 0; i < (int)call_data->preedit_attr_num; i++, pre_attr++) {
	if (Is (XNArea, pre_attr)) {
	    pre_attr->value = (void *)malloc(sizeof(XRectangle));
	    *(XRectangle*)pre_attr->value = rec->pre_attr.area;
	    pre_attr->value_length = sizeof(XRectangle);

	} else if (Is (XNAreaNeeded, pre_attr)) {
	    pre_attr->value = (void *)malloc(sizeof(XRectangle));
	    *(XRectangle*)pre_attr->value = rec->pre_attr.area_needed;
	    pre_attr->value_length = sizeof(XRectangle);
	
	} else if (Is (XNSpotLocation, pre_attr)) {
	    pre_attr->value = (void *)malloc(sizeof(XPoint));
	    *(XPoint*)pre_attr->value = rec->pre_attr.spot_location;
	    pre_attr->value_length = sizeof(XPoint);
	
	} else if (Is (XNFontSet, pre_attr)) {
	    CARD16 base_len = (CARD16)strlen(rec->pre_attr.base_font);
	    int total_len = sizeof(CARD16) + (CARD16)base_len;
	    char *p;

	    pre_attr->value = (void *)malloc(total_len);
	    p = (char *)pre_attr->value;
	    memmove(p, &base_len, sizeof(CARD16));
	    p += sizeof(CARD16);
	    strncpy(p, rec->pre_attr.base_font, base_len);
	    pre_attr->value_length = total_len;
	
	} else if (Is (XNForeground, pre_attr)) {
	    pre_attr->value = (void *)malloc(sizeof(long));
	    *(long*)pre_attr->value = rec->pre_attr.foreground;
	    pre_attr->value_length = sizeof(long);
	
	} else if (Is (XNBackground, pre_attr)) {
	    pre_attr->value = (void *)malloc(sizeof(long));
	    *(long*)pre_attr->value = rec->pre_attr.background;
	    pre_attr->value_length = sizeof(long);

	} else if (Is (XNLineSpace, pre_attr)) {
	    pre_attr->value = (void *)malloc(sizeof(long));
#if 0
	    *(long*)pre_attr->value = rec->pre_attr.line_space;
#endif
	    *(long*)pre_attr->value = 18;
	    pre_attr->value_length = sizeof(long);
	}
    }

    /* status attributes */
    for (i = 0; i < (int)call_data->status_attr_num; i++, sts_attr++) {
	if (Is (XNArea, sts_attr)) {
	    sts_attr->value = (void *)malloc(sizeof(XRectangle));
	    *(XRectangle*)sts_attr->value = rec->sts_attr.area;
	    sts_attr->value_length = sizeof(XRectangle);
	
	} else if (Is (XNAreaNeeded, sts_attr)) {
	    sts_attr->value = (void *)malloc(sizeof(XRectangle));
	    *(XRectangle*)sts_attr->value = rec->sts_attr.area_needed;
	    sts_attr->value_length = sizeof(XRectangle);
	
	} else if (Is (XNFontSet, sts_attr)) {
	    CARD16 base_len = (CARD16)strlen(rec->sts_attr.base_font);
	    int total_len = sizeof(CARD16) + (CARD16)base_len;
	    char *p;

	    sts_attr->value = (void *)malloc(total_len);
	    p = (char *)sts_attr->value;
	    memmove(p, &base_len, sizeof(CARD16));
	    p += sizeof(CARD16);
	    strncpy(p, rec->sts_attr.base_font, base_len);
	    sts_attr->value_length = total_len;
	
	} else if (Is (XNForeground, sts_attr)) {
	    sts_attr->value = (void *)malloc(sizeof(long));
	    *(long*)sts_attr->value = rec->sts_attr.foreground;
	    sts_attr->value_length = sizeof(long);
	
	} else if (Is (XNBackground, sts_attr)) {
	    sts_attr->value = (void *)malloc(sizeof(long));
	    *(long*)sts_attr->value = rec->sts_attr.background;
	    sts_attr->value_length = sizeof(long);
	
	} else if (Is (XNLineSpace, sts_attr)) {
	    sts_attr->value = (void *)malloc(sizeof(long));
#if 0
	    *(long*)sts_attr->value = rec->sts_attr.line_space;
#endif
	    *(long*)sts_attr->value = 18;
	    sts_attr->value_length = sizeof(long);
	}
    }
}
