<?php
// Xanhte Utility Class
class Xanhte_Util
{
    // EUCѴ
    function con_enc($value, $to_enc, $from_enc=_CHARSET){
	if(! function_exists('mb_convert_encoding')){
	    return $value ;
	}
	if( is_array($value)){
	    foreach($value as $key=>$var){
		$value[$key] = Xanhte_Util::con_enc($var, $to_enc, $from_enc) ;
	    }
	}else{
	    $value = mb_convert_encoding($value, $to_enc, $from_enc);
	}
	return $value ;
    }

    // ⥸塼Ѥθեɤ߹
    function includeModuleLanguageFiles($moduledir=null, $language=null){
		global $xoopsConfig, $xoopsModule ;
		if(empty($moduledir)) $moduledir = $xoopsModule->dirname();
		if(empty($language)) $language = $xoopsConfig['language'];
		$lang_dir = sprintf('%s/modules/%s/language/%s', XOOPS_ROOT_PATH, $moduledir, $language);

		$files = array('main','admin','modinfo','blocks');
		$include_files = array();
		foreach($files as $file){
			$langfile = sprintf('%s/%s.php',$lang_dir, $file);
			echo $langfile;
			if(file_exists($langfile)){
				require_once $langfile ;
				$include_files[] = $file ;
			}
		}
		return $include_files ;
    }
    
    // EthnaΥƥץ졼ȥåȤXOOPSΥƥץ졼ȥåȤ
    function defineReviseTmplPath(){
	if(defined('TMPLDIFF_E2X')) return null;
	
	$shared_path = '';
	$ethna_tmpl_dir = XANHTE_ROOT_PATH . '/template/ja';
	$xoops_tmpl_dir = XOOPS_ROOT_PATH . '/themes/some_theme_set_name';
	for($i=1; $i<(strlen($ethna_tmpl_dir)+strlen($xoops_tmpl_dir))/2; $i++ ){
	    if( strncmp($ethna_tmpl_dir, $xoops_tmpl_dir , $i)!=0 ){
		$shared_path = substr($ethna_tmpl_dir, 0, $i);
		break;
	    }
	}
	
	if(!$shared_path) exit('Cant find shared path.');
	
	$e_add_path = str_replace($shared_path, '', $ethna_tmpl_dir);
	$x_add_path = str_replace($shared_path, '', $xoops_tmpl_dir);

	define('TMPLDIFF', preg_replace('|[^\\/]+|', '..', $x_add_path).$e_add_path) ;
//	define('TMPLDIFF_X2E', preg_replace('|[^\\/]+|', '..', $x_add_path)) ;
	
	}


	/**
	 *	᡼ե򥢥åץɤ
	 *
	 *	@access	public
	 *  @param string ե̾
	 *  @param string åץХѥ
	 *  @param string ͥХѥ
	 *  @param int åץɤǤ1ե뤢κ祵(byte)
	 *  @param int åץɤǤ1եκ(pixel)
	 *  @param int åץɤǤ1եκ(pixel)
	 *  @param array ͥ
	 *	@return	array åפեξ
	 */	

	function uploadImageFiles($formname, $upload_path, $thumb_path, $max_file_size, $max_file_width, $max_file_height, $thumb_prop){

		require_once 'XanhteLib/xoops/myuploader.php';
		
		if(!isset($_FILES[$formname])){
			return array() ;
		}else{
			$_files = $_FILES[$formname] ;
		}
		// ǥ쥯ȥƤߤ
		if(@is_dir($upload_path) == false){
			mkdir($upload_path, 0755);
		}
		if(@is_dir($thumb_path) == false){
			mkdir($thumb_path, 0755);
		}
		$uploader =& new MyXoopsMediaUploader(
			$upload_path ,
			$allowed_mimetypes = array('image/gif', 'image/jpeg', 'image/pjpeg', 'image/x-png', 'image/png'),
			$max_file_size, $max_file_width, $max_file_height,
			$allowed_exts = array('gif','jpeg','jpg','png')
			);
		
		$savedFile = array();
		for($i=0; $i<count($_FILES[$formname]['name']); $i++){
			if( $uploader->fetchMedia($formname , $i) ){
				// ե̾ȳĥҤϼǥå
				$targetext = preg_match('/\.[a-z]+$/',strtolower($_files['name'][$i]), $matchext) ? $matchext[0] : '' ;
				$targetname = md5($_files['name'][$i].time().rand()) ;
				$uploader->setTargetFileName($targetname.$targetext);
				if($uploader->upload()){
					$uploaded_file = array(
						'filename' => $targetname ,
						'ext' => $targetext ,
						'res_x' => $uploader->mediaWidth,
						'res_y' => $uploader->mediaHeight,
					);
					$savedFile[] = $uploaded_file ;
				}else{
					echo $uploader->getErrors();
				}
			}
		}
		return $savedFile ;
	}
	
	/* uploadImageFilesƤФ뤳ȤͤƤʤǤ
	 * ͥäƥԡ
	 * @param $path: ֤ͥѥ
	 * @param $file_prop: Υץѥƥ array('filename'=>,'ext'=>,'res_x'=>,'res_y'=>);
	 * @param $thumb_prop: ͥ
	 * @param $creator: ɤβեȤѤ뤫 0=>GD 1=>imagemagick 2=>netBPM
	 * @return boolean: ɤ
	 */
	function createThumbnailImage($src_path, $thumb_path, $file_prop, $thumb_prop, $creator=0){
		// creatorGDǡimagecreatefromjpeg̵ϡñfalse֤
		if($creator==-0 && !function_exists('imagecreatefromjpeg')){
			return false ;
		}
		// myalbum-PΥͥϢեɤ߹
		require_once 'XanhteLib/xoops/myalbum-P_functions.php';
		// myalbum-PƱ褦ʴĶųݤ
		global $myalbum_imagingpipe , $myalbum_makethumb , $myalbum_normal_exts ;
		$myalbum_imagingpipe = $creator ;
		!isset($myalbum_makethumb) and $myalbum_makethumb = 1 ;
		!isset($myalbum_normal_exts) and $myalbum_normal_exts = array( 'jpg' , 'jpeg' , 'gif' , 'png' ) ;
		
		global $myalbum_forcegd2 , $thumbs_dir ;
		!isset($myalbum_forcegd2) and  $myalbum_forcegd2 = true ;
		!isset($thumbs_dir) and $thumbs_dir = $thumb_path ;
		
		global $myalbum_thumbsize , $myalbum_thumbrule ;
		!isset($myalbum_thumbsize) and $myalbum_thumbsize = $thumb_prop['size'] ;
		!isset($myalbum_thumbrule) and $myalbum_thumbrule = $thumb_prop['rule'] ;
		
		
		$node = $file_prop['filename'];
		$ext = $file_prop['ext'] ;
		$src_path = $src_path. '/'. $file_prop['filename'].'.' . $file_prop['ext'] ;
		$res = myalbum_create_thumb( $src_path , $node , $ext ) ;
		return $res ;
	}
	
	// ॾ9->+09:00Ȥ 9.5->+09:30Ȥˤ
	function convTZ($timezone){
		$min = sprintf('%02d', ($timezone - intval($timezone))*60) ;
		$hour = sprintf('%02d', intval($timezone)) ;
		$sign = $timezone > 0 ? '+' : '-' ;
		return sprintf('%s%s:%s',$sign, $hour, $min);
	}
	
	// YYYYMMDDhhiissͿ줿դunixtimeˤ롣
	function make_unixtime($yyyymmddhhiiss){
		// padding
		$yyyymmddhhiiss = sprintf('%-014s', $yyyymmddhhiiss);
		if(preg_match('/^(\d{4})(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/',$yyyymmddhhiiss, $match)){
			list($all, $y,$m,$d,$h,$i,$s) = $match ;
		}else{
			return 0 ;
		}
		$unixtime = mktime($h, $i, $s, $m, $d, $y);
		return $unixtime;
	}
	
	// unixtime桼ΥॾθΤˤ
	function fixTZ($time=0){
		global $xoopsUser, $xoopsConfig;

		$userTZ = is_object($xoopsUser) ? $xoopsUser->timezone() : $xoopsConfig['default_TZ'] ;
		$ret_time = $time - ($xoopsConfig['server_TZ'] - $userTZ)*3600 ;
		return $ret_time ;
	}
	
	// ʰץ˥ 
	function stz($string, $type='s'){
		$string = str_replace("\0", "", $string);
		switch($type){
		  case 'a-z0-9':
			$string = preg_replace("/[^\w]/", '' , $string);
			break ;
		  case 's' :
		  default:
		}
		return $string;
	}

	/**
	 *	XMLǤФ
	 *
	 *	@access	public
	 *	@return	string	XML
	 */
	function getXML($data, $root_tag, $addDecl=true){
	
		$options = array(
			"mode" => "simplexml" ,
			"indent"    => "    ",
			"linebreak" => "\n",
			"typeHints" => false,
			"addDecl"   => $addDecl,
			"encoding"  => 'UTF-8',
			"rootName"  => $root_tag,
			"defaultTagName" => "item",
			"attributesArray" => "_attributes",
			'cdata' => false,
			);		
		
		require_once XANHTE_ROOT_PATH.'/lib/XML/Serializer.php' ;
		$Serializer =& new XML_Serializer($options);
		$status = $Serializer->serialize($data);
		if (PEAR::isError($status)){
			die($status->getMessage());
		}
		
		return $Serializer->getSerializedData();
		
	
	}
	
	
	
	/**
	 *	AjaxǻȤ褦XMLǤФ
	 *
	 *	@access	protected
	 *	@return	string	XML
	 */
	function getXML4Ajax($data, $rootTag){
		
		return Xanhte_Util::getXML( array($rootTag=>$data), 'data');
	}	
	
	/**
	 * $xoopsTplȤäƤʤ顢xoops_module_headerxanhteJSɤ߹ޤ륹ץȥɲ
	 *
	 **/
	function addXanhteJS(){
	 // add xoops_block_header for css file
		global $xoopsTpl;
		if(!is_object($xoopsTpl) || defined('_ADD_XANHTE_COMMON_JS')){
			return null;
		}

		define('_ADD_XANHTE_COMMON_JS', 1);
		$xoops_module_header = $xoopsTpl->get_template_vars('xoops_module_header');
		$xoops_module_header .= sprintf('<script type="text/javascript" src="%s/modules/xanhte/js/xanhtecommon.js"></script>'."\n",XOOPS_URL);
		$xoopsTpl->assign('xoops_module_header', $xoops_module_header);
	}


	/**
	 * ǥ쥯ȥ꤫ǥ쥯ȥꥹȤ
	 * @access public
	 * @return array
	 **/
	function getDirectoryList($dir){
		$ret = array();
		$dh = opendir($dir);
		if ($dh) {
			while (($file = readdir($dh)) !== false) {
				if($file != '.' && $file != '..' && is_dir($dir.'/'.$file)){
					$ret[] = $file ;
				}
			}
		}
		closedir($dh);
		return $ret ;
	}
	 
}
?>