<?php
// vim: foldmethod=marker
/**
 *	Ethna_Backend.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_Backend.php,v 1.14 2005/09/22 03:32:51 fujimoto Exp $
 */

// {{{ Ethna_Backend
/**
 *	Хåɽ饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_Backend
{
	/**#@+
	 *	@access		private
	 */

	/**	@var	object	Ethna_Controller	controller֥ */
	var	$controller;

	/**	@var	object	Ethna_Controller	controller֥($controllerξά) */
	var	$ctl;

	/**	@var	object	Ethna_Config		ꥪ֥ */
	var	$config;

	/**	@var	object	Ethna_I18N			i18n֥ */
	var $i18n;

	/**	@var	object	Ethna_ActionError	󥨥顼֥ */
	var $action_error;

	/**	@var	object	Ethna_ActionError	󥨥顼֥($action_errorξά) */
	var $ae;

	/**	@var	object	Ethna_ActionForm	ե४֥ */
	var $action_form;

	/**	@var	object	Ethna_ActionForm	ե४֥($action_formξά) */
	var $af;

	/**	@var	object	Ethna_ActionClass	󥯥饹֥ */
	var $action_class;

	/**	@var	object	Ethna_ActionClass	󥯥饹֥($action_classξά) */
	var $ac;

	/**	@var	object	Ethna_Session		å󥪥֥ */
	var $session;

	/**	@var	array	Ethna_DB֥ȤǼ */
	var $db;

	/**	@var	object	Ethna_Logger		֥ */
	var $logger;

	/**	@var	array	ޥ͡㥪֥ȥå */
	var $manager = array();

	/**#@-*/


	/**
	 *	Ethna_Backend饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Controller	&$controller	ȥ饪֥
	 */
	function Ethna_Backend(&$controller)
	{
		// ֥Ȥ
		$this->controller =& $controller;
		$this->ctl =& $this->controller;

		$this->config =& $controller->getConfig();
		$this->i18n =& $controller->getI18N();

		$this->action_error =& $controller->getActionError();
		$this->ae =& $this->action_error;
		$this->action_form =& $controller->getActionForm();
		$this->af =& $this->action_form;
		$this->action_class = null;
		$this->ac =& $this->action_class;

		$this->session =& $this->controller->getSession();
		$this->db = array();
		$this->logger =& $this->controller->getLogger();

		// ޥ͡㥪֥Ȥ
		$manager_list = $controller->getManagerList();
		foreach ($manager_list as $key => $value) {
			$class_name = $this->controller->getManagerClassName($value);
			$this->manager[$value] =& new $class_name($this);
		}

		foreach ($manager_list as $key => $value) {
			foreach ($manager_list as $k => $v) {
				if ($v == $value) {
					/* skip myself */
					continue;
				}
				$this->manager[$value]->$k =& $this->manager[$v];
			}
		}
	}

	/**
	 *	controller֥ȤؤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_Controller	controller֥
	 */
	function &getController()
	{
		return $this->controller;
	}

	/**
	 *	ꥪ֥ȤؤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_Config		ꥪ֥
	 */
	function &getConfig()
	{
		return $this->config;
	}

	/**
	 *	ץꥱID֤
	 *
	 *	@access	public
	 *	@return	string	ץꥱID
	 */
	function getAppId()
	{
		return $this->controller->getAppId();
	}

	/**
	 *	I18N֥ȤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_I18N	i18n֥
	 */
	function &getI18N()
	{
		return $this->i18n;
	}

	/**
	 *	󥨥顼֥ȤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_ActionError	󥨥顼֥
	 */
	function &getActionError()
	{
		return $this->action_error;
	}

	/**
	 *	ե४֥ȤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_ActionForm	ե४֥
	 */
	function &getActionForm()
	{
		return $this->action_form;
	}

	/**
	 *	¹Υ󥯥饹֤
	 *
	 *	@access	public
	 *	@return	mixed	Ethna_ActionClass:󥯥饹 null:󥯥饹̤
	 */
	function &getActionClass()
	{
		return $this->action_class;
	}

	/**
	 *	֥ȤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_Logger	֥
	 */
	function &getLogger()
	{
		return $this->logger;
	}

	/**
	 *	å󥪥֥ȤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_Session	å󥪥֥
	 */
	function &getSession()
	{
		return $this->session;
	}

	/**
	 *	ޥ͡㥪֥ȤؤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_AppManager	ޥ͡㥪֥
	 */
	function &getManager($type)
	{
		if (isset($this->manager[$type])) {
			return $this->manager[$type];
		}
		return null;
	}

	/**
	 *	ץꥱΥ١ǥ쥯ȥ
	 *
	 *	@access	public
	 *	@return	string	١ǥ쥯ȥΥѥ̾
	 */
	function getBasedir()
	{
		return $this->controller->getBasedir();
	}

	/**
	 *	ץꥱΥƥץ졼ȥǥ쥯ȥ
	 *
	 *	@access	public
	 *	@return	string	ƥץ졼ȥǥ쥯ȥΥѥ̾
	 */
	function getTemplatedir()
	{
		return $this->controller->getTemplatedir();
	}

	/**
	 *	ץꥱǥ쥯ȥ
	 *
	 *	@access	public
	 *	@return	string	ǥ쥯ȥΥѥ̾
	 */
	function getEtcdir()
	{
		return $this->controller->getDirectory('etc');
	}

	/**
	 *	ץꥱΥƥݥǥ쥯ȥ
	 *
	 *	@access	public
	 *	@return	string	ƥݥǥ쥯ȥΥѥ̾
	 */
	function getTmpdir()
	{
		return $this->controller->getDirectory('tmp');
	}

	/**
	 *	ץꥱΥƥץ졼ȥեĥҤ
	 *
	 *	@access	public
	 *	@return	string	ƥץ졼ȥեγĥ
	 */
	function getTemplateext()
	{
		return $this->controller->getExt('tpl');
	}

	/**
	 *	߽Υ饤ȼ̤
	 *
	 *	@access	public
	 *	@return	int		饤ȼ
	 */
	function getClientType()
	{
		return $this->controller->getClientType();
	}

	/**
	 *	Ϥ
	 *
	 *	@access	public
	 *	@param	int		$level		٥(LOG_DEBUG, LOG_NOTICE...)
	 *	@param	string	$message	å(printf)
	 */
	function log($level, $message)
	{
		$args = func_get_args();
		if (count($args) > 2) {
			array_splice($args, 0, 2);
			$message = vsprintf($message, $args);
		}
		$this->logger->log($level, $message);
	}

	/**
	 *	Хåɽ¹Ԥ
	 *
	 *	@access	public
	 *	@param	string	$action_name	¹Ԥ륢̾
	 *	@return	mixed	(string):Forward̾(nullʤforwardʤ) Ethna_Error:顼
	 */
	function perform($action_name)
	{
		$forward_name = null;

		$action_class_name = $this->controller->getActionClassName($action_name);
		$this->action_class =& new $action_class_name($this);
		$this->ac =& $this->action_class;

		// μ¹
		$forward_name = $this->ac->authenticate();
		if ($forward_name === false) {
			return null;
		} else if ($forward_name !== null) {
			return $forward_name;
		}

		$forward_name = $this->ac->prepare();
		if ($forward_name === false) {
			return null;
		} else if ($forward_name !== null) {
			return $forward_name;
		}

		$forward_name = $this->ac->perform();

		return $forward_name;
	}

	/**
	 *	DB֥Ȥ֤
	 *
	 *	@access	public
	 *	@param	string	$type		DB(Ethna_Controller::dbФ)
	 *	@return	mixed	Ethna_DB:DB֥ null:DSNʤ Ethna_Error:顼
	 */
	function &getDB($type = "")
	{
		$key =& $this->_getDB($type);
		if (Ethna::isError($key)) {
			return $key;
		}
		if (isset($this->db[$key]) && $this->db[$key] != null) {
			return $this->db[$key];
		}

		$dsn = $this->controller->getDSN($type);
		if ($dsn == "") {
			// DB³
			return null;
		}
		$dsn_persistent = $this->controller->getDSN_persistent($type);

		$class_factory =& $this->controller->getClassFactory();
		$db_class_name = $class_factory->getObjectName('db');
		
		// BC: Ethna_DB -> Ethna_DB_PEAR
		if ($db_class_name == 'Ethna_DB') {
			$db_class_name = 'Ethna_DB_PEAR';
		}

		$this->db[$key] =& new $db_class_name($this->controller, $dsn, $dsn_persistent);
		$r = $this->db[$key]->connect();
		if (Ethna::isError($r)) {
			$this->db[$key] = null;
			return $r;
		}

//		register_shutdown_function(array($this, 'shutdownDB'));

		return $this->db[$key];
	}

	/**
	 *	DB֥()
	 *
	 *	@access	public
	 *	@return	mixed	array:Ethna_DB֥Ȥΰ Ethan_Error:(줫İʾ³)顼
	 *	@todo	respect access controlls
	 */
	function getDBList()
	{
		$r = array();
		foreach ($this->controller->db as $key => $value) {
			$db =& $this->getDB($key);
			if (Ethna::isError($db)) {
				return $r;
			}
			$elt = array();
			$elt['db'] =& $db;
			$elt['type'] = $value;
			$elt['varname'] = "db";
			if ($key != "") {
				$elt['varname'] = sprintf("db_%s", strtolower($key));
			}
			$r[] = $elt;
		}
		return $r;
	}

	/**
	 *	DBͥǤ
	 *
	 *	@access	public
	 */
	function shutdownDB()
	{
		foreach (array_keys($this->db) as $key) {
			if ($this->db[$key] != null && $this->db[$key]->isValid()) {
				$this->db[$key]->disconnect();
				unset($this->db[$key]);
			}
		}
	}

	/**
	 *	ꤵ줿DB̤б(DB֥ȤǼ뤿)ѿ̾
	 *
	 *	@access	private
	 *	@param	string	$type	DB
	 *	@return	mixed	string:ѿ̾ Ethna_Error:DB
	 */
	function &_getDB($type = "")
	{
		$r = $this->controller->getDBType($type);
		if (is_null($r)) {
			return Ethna::raiseError(E_DB_INVALIDTYPE, "̤DB[%s]", $type);
		}

		if ($type == "") {
			$key = "";
		} else {
			$key = sprintf("%s", strtolower($type));
		}

		return $key;
	}
}
// }}}
?>
