import * as vscode from 'vscode-languageserver/browser';
export * from 'vscode-languageserver/browser';
export * from './index';
export * from './lib/project/simpleProjectProvider';
export * from './lib/project/typescriptProjectProvider';
export * from './lib/server';
export declare function createConnection(): vscode.Connection;
export declare function createServer(connection: vscode.Connection): {
    connection: vscode.Connection;
    initializeParams: import("./index").VolarInitializeParams;
    languageServicePlugins: import("@volar/language-service").LanguageServicePlugin<any>[];
    projects: import("./index").ServerProjectProvider;
    fs: import("@volar/language-service").FileSystem;
    semanticTokensLegend: vscode.SemanticTokensLegend;
    pullModelDiagnostics: boolean;
    documents: vscode.TextDocuments<import("@volar/snapshot-document/lib/snapshotDocument").SnapshotDocument>;
    uriConverter: {
        uriToFileName: (uri: string, parsed?: import("vscode-uri").URI | undefined) => string;
        fileNameToUri: (fileName: string) => string;
    };
    workspaceFolders: {
        clear: () => void;
        values: () => IterableIterator<boolean>;
        keys: () => Generator<import("vscode-uri").URI, void, unknown>;
        delete: (uri: import("vscode-uri").URI) => boolean;
        get: (uri: import("vscode-uri").URI) => boolean | undefined;
        has: (uri: import("vscode-uri").URI) => boolean;
        set: (uri: import("vscode-uri").URI, item: boolean) => Map<string, boolean>;
    };
    initialize: (initializeParams: import("./index").VolarInitializeParams, languageServicePlugins: import("@volar/language-service").LanguageServicePlugin<any>[], projects: import("./index").ServerProjectProvider, options?: {
        semanticTokensLegend?: vscode.SemanticTokensLegend | undefined;
        pullModelDiagnostics?: boolean | undefined;
    } | undefined) => vscode.InitializeResult<any>;
    initialized: () => void;
    shutdown: () => Promise<void>;
    watchFiles: (patterns: string[]) => void;
    getConfiguration: <T>(section: string, scopeUri?: string | undefined) => Promise<T | undefined>;
    onDidChangeConfiguration: (cb: vscode.NotificationHandler<vscode.DidChangeConfigurationParams>) => {
        dispose(): void;
    };
    onDidChangeWatchedFiles: (cb: vscode.NotificationHandler<vscode.DidChangeWatchedFilesParams>) => {
        dispose: () => void;
    };
    clearPushDiagnostics: () => void;
    refresh: (projects: import("./index").ServerProjectProvider) => Promise<void>;
};
export declare function loadTsdkByUrl(tsdkUrl: string, locale: string | undefined): Promise<{
    typescript: typeof import("typescript");
    diagnosticMessages: import("typescript").MapLike<string> | undefined;
}>;
