/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.internal.CancellationUtil;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSSymbolsContentProvider
implements ICommonContentProvider,
ITreeContentProvider {
    public static final String VIEWER_PROPERTY_IS_QUICK_OUTLINE = "isQuickOutline";
    private TreeViewer viewer;
    private volatile Throwable lastError;
    private OutlineViewerInput outlineViewerInput;
    private final SymbolsModel symbolsModel = new SymbolsModel();
    private volatile CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> symbols;
    private final boolean refreshOnResourceChanged;
    private boolean isQuickOutline;
    private IOutlineUpdater outlineUpdater;

    public LSSymbolsContentProvider() {
        this(false);
    }

    public LSSymbolsContentProvider(boolean refreshOnResourceChanged) {
        this.refreshOnResourceChanged = refreshOnResourceChanged;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.outlineUpdater != null) {
            this.outlineUpdater.uninstall();
        }
        if (newInput == null) {
            return;
        }
        this.viewer = (TreeViewer)viewer;
        this.isQuickOutline = Boolean.TRUE.equals(viewer.getData(VIEWER_PROPERTY_IS_QUICK_OUTLINE));
        this.outlineViewerInput = (OutlineViewerInput)newInput;
        this.symbolsModel.setUri(this.outlineViewerInput.documentURI);
        this.refreshTreeContentFromLS();
        if (!this.isQuickOutline) {
            this.outlineUpdater = this.createOutlineUpdater();
            this.outlineUpdater.install();
        }
    }

    private IOutlineUpdater createOutlineUpdater() {
        if (this.refreshOnResourceChanged) {
            return new ResourceChangeOutlineUpdater((IResource)this.outlineViewerInput.documentFile);
        }
        ITextViewer textViewer = LSPEclipseUtils.getTextViewer((IEditorPart)this.outlineViewerInput.textEditor);
        return textViewer == null ? new DocumentChangedOutlineUpdater(this.outlineViewerInput.document) : new ReconcilerOutlineUpdater(textViewer);
    }

    public Object[] getElements(Object inputElement) {
        if (this.symbols != null && !this.symbols.isDone()) {
            return new Object[]{new PendingUpdateAdapter()};
        }
        if (this.lastError != null && this.symbolsModel.getElements().length == 0) {
            return new Object[]{"An error occured, see log for details"};
        }
        return this.symbolsModel.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        return this.symbolsModel.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.symbolsModel.getParent(element);
    }

    public boolean hasChildren(Object parentElement) {
        return this.symbolsModel.hasChildren(parentElement);
    }

    protected void refreshTreeContentFromLS() {
        URI documentURI = this.outlineViewerInput.documentURI;
        if (documentURI == null) {
            IllegalStateException exception = new IllegalStateException("documentURI == null");
            this.lastError = exception;
            LanguageServerPlugin.logError(exception);
            this.viewer.getControl().getDisplay().asyncExec(() -> ((TreeViewer)this.viewer).refresh());
            return;
        }
        if (this.symbols != null) {
            this.symbols.cancel(true);
        }
        DocumentSymbolParams params = new DocumentSymbolParams(LSPEclipseUtils.toTextDocumentIdentifier(documentURI));
        this.symbols = this.outlineViewerInput.wrapper.execute(ls -> ls.getTextDocumentService().documentSymbol(params));
        this.symbols.thenAcceptAsync(response -> {
            this.symbolsModel.update((List<Either<SymbolInformation, DocumentSymbol>>)response);
            this.lastError = null;
            boolean linkWithEditor = this.isQuickOutline || InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").getBoolean("org.eclipse.lsp4e.outline.linkWithEditor", true);
            this.viewer.getControl().getDisplay().asyncExec(() -> {
                ITextEditor editor;
                if (this.viewer.getTree().isDisposed()) {
                    return;
                }
                if (this.isQuickOutline) {
                    this.viewer.refresh();
                } else {
                    TreePath[] expandedElements = this.viewer.getExpandedTreePaths();
                    TreePath[] initialSelection = ((ITreeSelection)this.viewer.getSelection()).getPaths();
                    this.viewer.refresh();
                    this.viewer.setExpandedTreePaths((TreePath[])Arrays.stream(expandedElements).map(this.symbolsModel::toUpdatedSymbol).filter(Objects::nonNull).toArray(TreePath[]::new));
                    this.viewer.setSelection((ISelection)new TreeSelection((TreePath[])Arrays.stream(initialSelection).map(this.symbolsModel::toUpdatedSymbol).filter(Objects::nonNull).toArray(TreePath[]::new)));
                }
                if (linkWithEditor && (editor = UI.getActiveTextEditor()) != null) {
                    ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                    CNFOutlinePage.refreshTreeSelection(this.viewer, selection.getOffset(), this.outlineViewerInput.document);
                }
            });
        });
        this.symbols.exceptionally(ex -> {
            if (!(ex instanceof CancellationException) && !CancellationUtil.isRequestCancelledException(ex)) {
                this.lastError = ex;
                LanguageServerPlugin.logError(ex);
            }
            this.viewer.getControl().getDisplay().asyncExec(() -> ((TreeViewer)this.viewer).refresh());
            return Collections.emptyList();
        });
    }

    public void dispose() {
        if (this.outlineUpdater != null) {
            this.outlineUpdater.uninstall();
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    private final class DocumentChangedOutlineUpdater
    implements IDocumentListener,
    IOutlineUpdater {
        private final IDocument document;

        DocumentChangedOutlineUpdater(IDocument document) {
            this.document = document;
        }

        @Override
        public void install() {
            this.document.addDocumentListener((IDocumentListener)this);
            LSSymbolsContentProvider.this.refreshTreeContentFromLS();
        }

        @Override
        public void uninstall() {
            this.document.removeDocumentListener((IDocumentListener)this);
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            LSSymbolsContentProvider.this.refreshTreeContentFromLS();
        }
    }

    static interface IOutlineUpdater {
        public void install();

        public void uninstall();
    }

    @NonNullByDefault
    public static final class OutlineViewerInput {
        public final IDocument document;
        public final LanguageServerWrapper wrapper;
        public final @Nullable ITextEditor textEditor;
        public final @Nullable IFile documentFile;
        private final @Nullable URI documentURI;

        public OutlineViewerInput(IDocument document, @NonNull LanguageServerWrapper wrapper, @Nullable ITextEditor textEditor) {
            this.document = document;
            IPath path = LSPEclipseUtils.toPath(document);
            if (path == null) {
                this.documentFile = null;
                URI uri = null;
                URI docUri = LSPEclipseUtils.toUri(document);
                if (docUri != null) {
                    TextDocumentIdentifier docIdentifier = LSPEclipseUtils.toTextDocumentIdentifier(docUri);
                    try {
                        uri = new URI(docIdentifier.getUri());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                this.documentURI = uri;
            } else {
                IFile file;
                this.documentFile = file = LSPEclipseUtils.getFile(path);
                this.documentURI = file == null ? path.toFile().toURI() : LSPEclipseUtils.toUri((IResource)file);
            }
            this.wrapper = wrapper;
            this.textEditor = textEditor;
        }
    }

    private final class ReconcilerOutlineUpdater
    extends AbstractReconciler
    implements IOutlineUpdater {
        private final ITextViewer textViewer;

        ReconcilerOutlineUpdater(ITextViewer textViewer) {
            this.textViewer = textViewer;
            super.setIsIncrementalReconciler(false);
            super.setIsAllowedToModifyDocument(false);
        }

        @Override
        public void install() {
            super.install(this.textViewer);
        }

        protected void initialProcess() {
            LSSymbolsContentProvider.this.refreshTreeContentFromLS();
        }

        protected void process(DirtyRegion dirtyRegion) {
            LSSymbolsContentProvider.this.refreshTreeContentFromLS();
        }

        protected void reconcilerDocumentChanged(IDocument newDocument) {
        }

        public IReconcilingStrategy getReconcilingStrategy(String contentType) {
            return null;
        }
    }

    private final class ResourceChangeOutlineUpdater
    implements IResourceChangeListener,
    IOutlineUpdater {
        private final IResource resource;

        public ResourceChangeOutlineUpdater(IResource resource) {
            this.resource = resource;
        }

        @Override
        public void install() {
            this.resource.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }

        @Override
        public void uninstall() {
            this.resource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if ((event.getDelta().getFlags() ^ 0x20000) != 0) {
                try {
                    event.getDelta().accept(delta -> {
                        if (delta.getResource().equals((Object)this.resource)) {
                            LSSymbolsContentProvider.this.viewer.getControl().getDisplay().asyncExec(() -> {
                                if (!LSSymbolsContentProvider.this.viewer.getControl().isDisposed() && LSSymbolsContentProvider.this.viewer instanceof StructuredViewer) {
                                    LSSymbolsContentProvider.this.viewer.refresh(true);
                                }
                            });
                        }
                        return delta.getResource().getFullPath().isPrefixOf(this.resource.getFullPath());
                    });
                }
                catch (CoreException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
    }
}

