/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.net.URI;
import java.util.AbstractMap;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.enablement.EnablementTester;

public class ContentTypeToLanguageServerDefinition
extends AbstractMap.SimpleEntry<IContentType, LanguageServersRegistry.LanguageServerDefinition> {
    private static final long serialVersionUID = 6002703726009331762L;
    private final EnablementTester enablement;

    public ContentTypeToLanguageServerDefinition(@NonNull IContentType contentType, @NonNull LanguageServersRegistry.LanguageServerDefinition provider, @Nullable EnablementTester enablement) {
        super(contentType, provider);
        this.enablement = enablement;
    }

    public boolean isEnabled(URI uri) {
        return this.isUserEnabled() && this.isExtensionEnabled(uri);
    }

    public void setUserEnabled(boolean enabled) {
        LanguageServerPlugin.getDefault().getPreferenceStore().setValue(this.getPreferencesKey(), String.valueOf(enabled));
    }

    public boolean isUserEnabled() {
        if (LanguageServerPlugin.getDefault().getPreferenceStore().contains(this.getPreferencesKey())) {
            return LanguageServerPlugin.getDefault().getPreferenceStore().getBoolean(this.getPreferencesKey());
        }
        return true;
    }

    public boolean isExtensionEnabled(URI uri) {
        return this.enablement != null ? this.enablement.evaluate(uri) : true;
    }

    public EnablementTester getEnablementCondition() {
        return this.enablement;
    }

    private String getPreferencesKey() {
        return ((LanguageServersRegistry.LanguageServerDefinition)this.getValue()).id + "/" + ((IContentType)this.getKey()).getId();
    }
}

