/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.model;

import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.internal.core.model.SystemRegistry;

public final class RemoteObjectId {
    private final ISubSystem fSubSystem;
    private final String fAbsoluteName;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.internal.core.model.RemoteObjectId");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private RemoteObjectId(ISubSystem ss, String absoluteName) {
        if (!$assertionsDisabled && absoluteName == null) {
            throw new AssertionError();
        }
        this.fSubSystem = ss;
        this.fAbsoluteName = absoluteName;
    }

    public static RemoteObjectId create(Object element) {
        String absoluteName;
        ISystemDragDropAdapter dda = SystemRegistry.getSystemDragDropAdapter(element);
        if (dda != null && (absoluteName = dda.getAbsoluteName(element)) != null) {
            return new RemoteObjectId(dda.getSubSystem(element), absoluteName);
        }
        return null;
    }

    public final String getAbsoluteName() {
        return this.fAbsoluteName;
    }

    public final ISubSystem getSubSystem() {
        return this.fSubSystem;
    }

    public final boolean equals(Object o) {
        try {
            RemoteObjectId other = (RemoteObjectId)o;
            return this.fSubSystem == other.fSubSystem && this.fAbsoluteName.equals(other.fAbsoluteName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public final int hashCode() {
        int hashCode = this.fAbsoluteName.hashCode();
        if (this.fSubSystem != null) {
            hashCode = hashCode * 31 + this.fSubSystem.hashCode();
        }
        return hashCode;
    }
}

